/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCFileTypeHelper;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCHeaderFileTypeDetector
implements FileTypeRegistry.FileTypeDetector {
    public FileType detect(@NotNull VirtualFile file2, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
        IElementType tt;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/lang/OCHeaderFileTypeDetector", "detect"));
        }
        if (firstBytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstBytes", "com/jetbrains/cidr/lang/OCHeaderFileTypeDetector", "detect"));
        }
        if (firstCharsIfText == null) {
            return null;
        }
        for (OCFileTypeHelper each : OCFileTypeHelpers.getHelpers()) {
            FileType type = each.getFileType(file2);
            if (type == null) {
                return null;
            }
            if (type == FileTypes.UNKNOWN) continue;
            return type;
        }
        OCLexer lexer = new OCLexer();
        lexer.start(firstCharsIfText);
        boolean atNewLine = true;
        boolean wasDirective = false;
        int identsInSequence = 0;
        while ((tt = lexer.getTokenType()) != null) {
            if (tt == OCTokenTypes.UNKNOWN_DIRECTIVE || tt == TokenType.BAD_CHARACTER) {
                lexer.advance();
                if (lexer.getTokenType() == null) break;
                return null;
            }
            if (OCTokenTypes.COMMENTS.contains(tt)) {
                identsInSequence = 0;
            } else if (OCTokenTypes.WHITESPACES.contains(tt)) {
                if (lexer.getTokenText().contains("\n")) {
                    atNewLine = true;
                }
            } else if (tt == OCTokenTypes.IDENTIFIER) {
                if (++identsInSequence > 7) {
                    return null;
                }
                atNewLine = false;
            } else if (OCTokenTypes.DIRECTIVES.contains(tt) && atNewLine) {
                wasDirective = true;
                atNewLine = false;
                identsInSequence = 0;
            } else {
                atNewLine = false;
                identsInSequence = 0;
            }
            lexer.advance();
        }
        return wasDirective ? OCFileType.INSTANCE : null;
    }

    public int getVersion() {
        return 1;
    }
}

