/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.PlatformUtils;
import com.jetbrains.cidr.lang.OCLanguageKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum CLanguageKind implements OCLanguageKind
{
    C("C", "c"),
    OBJ_C("Objective-C", "m"),
    CPP("C++", "cpp"),
    OBJ_CPP("Objective-C++", "mm");

    public static final Key<CLanguageKind> MAX_LANGUAGE_KIND_KEY;
    private final String myDefaultSourceExtension;
    private final String myDisplayName;

    private CLanguageKind(String name, String extension) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/CLanguageKind", "<init>"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/jetbrains/cidr/lang/CLanguageKind", "<init>"));
        }
        this.myDefaultSourceExtension = extension;
        this.myDisplayName = name;
    }

    @NotNull
    public static CLanguageKind maxLanguage(@Nullable Project project) {
        CLanguageKind predefined;
        CLanguageKind cLanguageKind = predefined = project != null ? (CLanguageKind)project.getUserData(MAX_LANGUAGE_KIND_KEY) : null;
        if (predefined != null) {
            CLanguageKind cLanguageKind2 = predefined;
            if (cLanguageKind2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/CLanguageKind", "maxLanguage"));
            }
            return cLanguageKind2;
        }
        CLanguageKind cLanguageKind3 = PlatformUtils.isAppCode() ? OBJ_CPP : CPP;
        if (cLanguageKind3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/CLanguageKind", "maxLanguage"));
        }
        return cLanguageKind3;
    }

    @NotNull
    public static CLanguageKind min(@NotNull CLanguageKind a, @NotNull CLanguageKind b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/jetbrains/cidr/lang/CLanguageKind", "min"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/jetbrains/cidr/lang/CLanguageKind", "min"));
        }
        if (a == b) {
            CLanguageKind cLanguageKind = a;
            if (cLanguageKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/CLanguageKind", "min"));
            }
            return cLanguageKind;
        }
        if (a == C || b == C) {
            CLanguageKind cLanguageKind = C;
            if (cLanguageKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/CLanguageKind", "min"));
            }
            return cLanguageKind;
        }
        if (a == OBJ_C && b == CPP) {
            CLanguageKind cLanguageKind = C;
            if (cLanguageKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/CLanguageKind", "min"));
            }
            return cLanguageKind;
        }
        if (b == OBJ_C && a == CPP) {
            CLanguageKind cLanguageKind = C;
            if (cLanguageKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/CLanguageKind", "min"));
            }
            return cLanguageKind;
        }
        if (a == OBJ_C && b == OBJ_CPP) {
            CLanguageKind cLanguageKind = OBJ_C;
            if (cLanguageKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/CLanguageKind", "min"));
            }
            return cLanguageKind;
        }
        if (b == OBJ_C && a == OBJ_CPP) {
            CLanguageKind cLanguageKind = OBJ_C;
            if (cLanguageKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/CLanguageKind", "min"));
            }
            return cLanguageKind;
        }
        if (a == CPP && b == OBJ_CPP) {
            CLanguageKind cLanguageKind = CPP;
            if (cLanguageKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/CLanguageKind", "min"));
            }
            return cLanguageKind;
        }
        if (b == CPP && a == OBJ_CPP) {
            CLanguageKind cLanguageKind = CPP;
            if (cLanguageKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/CLanguageKind", "min"));
            }
            return cLanguageKind;
        }
        CLanguageKind cLanguageKind = a;
        if (cLanguageKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/CLanguageKind", "min"));
        }
        return cLanguageKind;
    }

    @Nullable
    public static CLanguageKind fromCompilerSetting(@Nullable String setting) {
        if ("objective-c".equals(setting)) {
            return OBJ_C;
        }
        if ("objective-c++".equals(setting)) {
            return OBJ_CPP;
        }
        if ("c".equals(setting)) {
            return C;
        }
        if ("c++".equals(setting)) {
            return CPP;
        }
        return null;
    }

    @Override
    public boolean isCpp() {
        return this == CPP || this == OBJ_CPP;
    }

    @Override
    public boolean isObjC() {
        return this == OBJ_C || this == OBJ_CPP;
    }

    @Override
    public boolean conforms(@NotNull OCLanguageKind requiredKind) {
        if (requiredKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredKind", "com/jetbrains/cidr/lang/CLanguageKind", "conforms"));
        }
        return !(!this.isObjC() && requiredKind.isObjC() || !this.isCpp() && requiredKind.isCpp());
    }

    @Override
    @NotNull
    public String getDefaultSourceExtension() {
        String string = this.myDefaultSourceExtension;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/CLanguageKind", "getDefaultSourceExtension"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/CLanguageKind", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean supportsPrecompiledHeaders() {
        return true;
    }

    static {
        MAX_LANGUAGE_KIND_KEY = Key.create((String)"MAX_LANGUAGE_KIND_KEY");
    }
}

