/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.generate.handlers;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.cidr.lang.generate.actions.OCActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassTextActionHandlerBase;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCAbstractGenerateTestHandler<P extends OCMembersContainer, M extends OCSymbolWithParent<?, ?>, C extends OCActionContext<P, M>>
extends OCClassTextActionHandlerBase<P, M, C> {
    private static final Logger LOG = Logger.getInstance((String)OCAbstractGenerateTestHandler.class.getName());
    private final String myActionTitle;
    private final String myTemplateName;

    protected OCAbstractGenerateTestHandler(String actionTitle, String templateName) {
        this.myActionTitle = actionTitle;
        this.myTemplateName = templateName;
    }

    @Override
    protected String getActionTitle() {
        return this.myActionTitle;
    }

    @Override
    protected String getMembersChooserTitle() {
        return "";
    }

    @Override
    protected boolean enableChooseDialog(Collection<M> candidates) {
        return false;
    }

    @Override
    protected boolean allowEmptySelection(C context) {
        return true;
    }

    @Override
    @Nullable
    protected String getInsertText(PsiElement element, PsiElement at, List<M> members, C actionContext) {
        return null;
    }

    @NotNull
    private Template createTestMethodTemplate(@NotNull FileTemplateDescriptor templateDesc, Project project) {
        if (templateDesc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateDesc", "com/jetbrains/cidr/generate/handlers/OCAbstractGenerateTestHandler", "createTestMethodTemplate"));
        }
        Template template = TemplateManager.getInstance(project).createTemplate("", "");
        String templateText = this.getTemplateText(templateDesc, project);
        int from = 0;
        Pattern pattern = Pattern.compile("\\$\\{(\\w+)}");
        Matcher m = pattern.matcher(templateText);
        HashSet<String> createdVariables = new HashSet<String>();
        while (m.find()) {
            String name = m.group(1);
            template.addTextSegment(templateText.substring(from, m.start()));
            if (name.equals("END")) {
                template.addEndVariable();
            } else if (createdVariables.contains(name)) {
                template.addVariableSegment(name);
            } else {
                ConstantNode nameExpr = new ConstantNode(name);
                template.addVariable(name, nameExpr, nameExpr, true);
                createdVariables.add(name);
            }
            from = m.end();
        }
        template.addTextSegment(templateText.substring(from, templateText.length()));
        template.setToIndent(true);
        template.setToReformat(true);
        template.setToShortenLongNames(true);
        Template template2 = template;
        if (template2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/generate/handlers/OCAbstractGenerateTestHandler", "createTestMethodTemplate"));
        }
        return template2;
    }

    @NotNull
    protected String getTemplateText(@NotNull FileTemplateDescriptor templateDesc, Project project) {
        String templateText;
        if (templateDesc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateDesc", "com/jetbrains/cidr/generate/handlers/OCAbstractGenerateTestHandler", "getTemplateText"));
        }
        String templateName = templateDesc.getFileName();
        FileTemplate fileTemplate = FileTemplateManager.getInstance(project).getCodeTemplate(templateName);
        try {
            templateText = fileTemplate.getText(new Properties());
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            templateText = fileTemplate.getText();
        }
        String string = templateText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/generate/handlers/OCAbstractGenerateTestHandler", "getTemplateText"));
        }
        return string;
    }

    @Override
    protected void performAction(Project project, PsiElement element, int caretPos, @Nullable PsiElement at, List<M> members, C auxInfo) {
        final PsiFile file2 = element.getContainingFile();
        final Editor editor = EditorHelper.openInEditor((PsiElement)file2);
        final int insertPosition = this.getInsertPosition(element, caretPos, at, members, auxInfo);
        if (insertPosition == -1) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Action is invalid for the current caret position", (String)this.getActionTitle(), null);
            return;
        }
        editor.getCaretModel().moveToOffset(insertPosition);
        FileTemplateDescriptor fileTemplateDescriptor = new FileTemplateDescriptor(this.myTemplateName);
        Template template = this.createTestMethodTemplate(fileTemplateDescriptor, project);
        TemplateManager.getInstance(project).startTemplate(editor, template, new TemplateEditingAdapter(){

            @Override
            public void templateFinished(Template template, boolean brokenOff) {
                PsiElement element = file2.findElementAt(insertPosition);
                if (element instanceof PsiWhiteSpace) {
                    element = element.getNextSibling();
                }
                if (element != null) {
                    RangeMarker rangeMarker = editor.getDocument().createRangeMarker(element.getTextRange());
                    OCAbstractGenerateTestHandler.this.onTemplateFinished(file2, rangeMarker);
                    OCAbstractGenerateTestHandler.this.selectResult(file2, rangeMarker);
                }
            }
        });
    }

    protected void onTemplateFinished(@NotNull PsiFile file2, @NotNull RangeMarker rangeMarker) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/generate/handlers/OCAbstractGenerateTestHandler", "onTemplateFinished"));
        }
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/jetbrains/cidr/generate/handlers/OCAbstractGenerateTestHandler", "onTemplateFinished"));
        }
    }
}

