/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.testing.CidrTestUtil;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGoogleTestLocationProvider
implements SMTestLocator {
    public static final String PROTOCOL = "gtest";
    public static final OCGoogleTestLocationProvider INSTANCE = new OCGoogleTestLocationProvider();
    private static final Pattern METHOD_PATTERN = Pattern.compile("((\\w+)/)?(\\w+)(\\.(\\w+))?(=(\\d+))?(\\?typed)?");

    @Override
    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/jetbrains/cidr/execution/testing/OCGoogleTestLocationProvider", "getLocation"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/cidr/execution/testing/OCGoogleTestLocationProvider", "getLocation"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/execution/testing/OCGoogleTestLocationProvider", "getLocation"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/cidr/execution/testing/OCGoogleTestLocationProvider", "getLocation"));
        }
        if (!PROTOCOL.equals(protocol)) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/OCGoogleTestLocationProvider", "getLocation"));
            }
            return list;
        }
        Matcher matcher = METHOD_PATTERN.matcher(path);
        if (matcher.matches()) {
            boolean typed;
            String instantiationName = matcher.group(2);
            String suiteName = matcher.group(3);
            String testName = matcher.group(5);
            String param = matcher.group(7);
            boolean bl = typed = matcher.group(8) != null;
            OCSymbol<OCElement> symbol = testName != null ? CidrTestUtil.findGoogleTestSymbol(project, suiteName, testName) : (instantiationName != null ? CidrTestUtil.findGoogleTestInstantiationSymbol(project, suiteName, instantiationName) : OCGoogleTestLocationProvider.findSuiteSymbol(project, suiteName));
            if (symbol == null) {
                List<Location> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/OCGoogleTestLocationProvider", "getLocation"));
                }
                return list;
            }
            OCElement psiElement = symbol.locateDefinition();
            while (!(psiElement instanceof OCStruct) && !(psiElement instanceof OCMacroCall) && psiElement != null) {
                PsiElement prev = psiElement.getPrevSibling();
                psiElement = prev == null ? psiElement.getParent() : prev;
            }
            if (psiElement == null) {
                List<Location> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/OCGoogleTestLocationProvider", "getLocation"));
                }
                return list;
            }
            List<OCGoogleTestLocation> list = Collections.singletonList(new OCGoogleTestLocation(project, psiElement, param, instantiationName, testName == null, typed));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/OCGoogleTestLocationProvider", "getLocation"));
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/OCGoogleTestLocationProvider", "getLocation"));
        }
        return list;
    }

    private static OCStructSymbol findSuiteSymbol(Project project, String suiteName) {
        CommonProcessors.FindProcessor<OCSymbol> processor2 = new CommonProcessors.FindProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCStructSymbol && CidrTestUtil.isGoogleTestClass((OCStructSymbol)symbol);
            }
        };
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project, (Processor<OCSymbol>)processor2, suiteName);
        if (processor2.isFound()) {
            return (OCStructSymbol)processor2.getFoundValue();
        }
        Collection<OCStructSymbol> symbolsForSuite = CidrTestUtil.findGoogleTestSymbolsForSuiteSorted(project, suiteName);
        return symbolsForSuite.isEmpty() ? null : symbolsForSuite.iterator().next();
    }

    public static class OCGoogleTestLocation
    extends PsiLocation<PsiElement> {
        private final String myParam;
        private final String myInstantiation;
        private final boolean mySuiteOnly;
        private final boolean myTyped;

        public OCGoogleTestLocation(@NotNull Project project, @NotNull PsiElement psiElement, @Nullable String param, @Nullable String instantiation, boolean suiteOnly, boolean typed) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/execution/testing/OCGoogleTestLocationProvider$OCGoogleTestLocation", "<init>"));
            }
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/cidr/execution/testing/OCGoogleTestLocationProvider$OCGoogleTestLocation", "<init>"));
            }
            super(project, psiElement);
            this.myParam = param;
            this.myInstantiation = instantiation;
            this.mySuiteOnly = suiteOnly;
            this.myTyped = typed;
        }

        public String getParam() {
            return this.myParam;
        }

        public String getInstantiation() {
            return this.myInstantiation;
        }

        public boolean isSuiteOnly() {
            return this.mySuiteOnly;
        }

        public boolean isTyped() {
            return this.myTyped;
        }
    }
}

