/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.Location;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildTargetWithConfigurations;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrTargetHolder;
import com.jetbrains.cidr.execution.testing.CidrGoogleTestCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrGoogleTestObject;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationProducer;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestUtil;
import com.jetbrains.cidr.execution.testing.OCGoogleTestLocationProvider;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrGoogleTestRunConfigurationProducer<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTargetWithConfigurations<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>>
extends CidrTestRunConfigurationProducer<BC, TARGET, CONFIGURATION, CidrGoogleTestObject> {
    protected CidrGoogleTestRunConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    protected PsiElement getElement(@NotNull CidrGoogleTestObject testObj) {
        if (testObj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testObj", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationProducer", "getElement"));
        }
        PsiElement psiElement = testObj.element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationProducer", "getElement"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    protected List<TARGET> getTargetFromTest(@NotNull CidrGoogleTestObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationProducer", "getTargetFromTest"));
        }
        PsiFile containingFile = this.getElement(object).getContainingFile();
        ArrayList<CidrBuildTargetWithConfigurations> targets = new ArrayList<CidrBuildTargetWithConfigurations>();
        for (OCResolveConfiguration oCResolveConfiguration : OCInclusionContextUtil.getAllBuildConfigurationsForFile(containingFile, null)) {
            assert (oCResolveConfiguration instanceof CidrTargetHolder);
            CidrBuildTargetWithConfigurations target = (CidrBuildTargetWithConfigurations)((CidrTargetHolder)((Object)oCResolveConfiguration)).getTarget();
            if (!target.isExecutable()) continue;
            targets.add(target);
        }
        ArrayList<CidrBuildTargetWithConfigurations> arrayList = targets;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationProducer", "getTargetFromTest"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    protected CidrTestRunConfigurationProducer.Scope determineScope(@NotNull List<CidrGoogleTestObject> testObj) {
        if (testObj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testObj", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationProducer", "determineScope"));
        }
        return this.determineScope(testObj, ":");
    }

    @Override
    @NotNull
    protected CidrTestScopeElement createScopeElement(@NotNull CidrTestRunConfigurationProducer.Scope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationProducer", "createScopeElement"));
        }
        CidrGoogleTestCommandLineState.OCGoogleTestScopeElement oCGoogleTestScopeElement = new CidrGoogleTestCommandLineState.OCGoogleTestScopeElement(scope.suite, scope.test, null, null);
        if (oCGoogleTestScopeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationProducer", "createScopeElement"));
        }
        return oCGoogleTestScopeElement;
    }

    @Override
    @Nullable
    protected CidrTestRunConfigurationProducer.Scope determineScope(@NotNull CidrGoogleTestObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationProducer", "determineScope"));
        }
        if (object.kind == CidrGoogleTestObject.KIND.FILE) {
            Collection classes = PsiTreeUtil.findChildrenOfType((PsiElement)this.getElement(object), OCStruct.class);
            List suiteNames = ContainerUtil.mapNotNull((Collection)classes, (Function)new Function<OCStruct, String>(){

                public String fun(OCStruct s) {
                    OCStructSymbol symbol = (OCStructSymbol)s.getSymbol();
                    if (symbol == null || !CidrTestUtil.isGoogleTestClass(symbol)) {
                        return null;
                    }
                    Couple<String> pair = CidrTestUtil.extractGoogleTestName((OCStructSymbol)s.getSymbol());
                    return pair == null ? s.getName() : (String)pair.first;
                }
            });
            if (!suiteNames.isEmpty()) {
                Function<String, CidrGoogleTestCommandLineState.OCGoogleTestScopeElement> f = new Function<String, CidrGoogleTestCommandLineState.OCGoogleTestScopeElement>(){

                    @Contract(value="_ -> !null")
                    public CidrGoogleTestCommandLineState.OCGoogleTestScopeElement fun(String s) {
                        return new CidrGoogleTestCommandLineState.OCGoogleTestScopeElement(s, null, null, null);
                    }
                };
                return new CidrTestRunConfigurationProducer.Scope(null, null, CidrBundle.message("ocunit.defaultName.allTestsIn", ((OCFile)this.getElement(object)).getName()), StringUtil.join((Iterable)ContainerUtil.map(new LinkedHashSet(suiteNames), (Function)f), (String)":"));
            }
            return null;
        }
        Couple<String> res = CidrTestUtil.extractGoogleTestName((OCStructSymbol)((OCStruct)this.getElement(object)).getSymbol());
        if (res == null) {
            if (object.param == null) {
                return new CidrTestRunConfigurationProducer.Scope(((OCStruct)this.getElement(object)).getName(), null, null, null);
            }
            String suiteName = ((OCStruct)this.getElement(object)).getName();
            return new CidrTestRunConfigurationProducer.Scope(null, null, suiteName, new CidrGoogleTestCommandLineState.OCGoogleTestScopeElement(suiteName, null, null, object.param).toString());
        }
        if (object.param == null && object.instantiation == null) {
            return new CidrTestRunConfigurationProducer.Scope((String)res.first, object.kind == CidrGoogleTestObject.KIND.TEST ? (String)res.second : null, null, null);
        }
        String testName = object.kind == CidrGoogleTestObject.KIND.TEST ? (String)res.second : null;
        String configurationName = (String)res.first;
        if (object.instantiation != null) {
            configurationName = object.instantiation + "-" + configurationName;
        }
        if (testName != null) {
            configurationName = configurationName + "." + testName;
        }
        return new CidrTestRunConfigurationProducer.Scope(null, null, configurationName, new CidrGoogleTestCommandLineState.OCGoogleTestScopeElement((String)res.first, testName, object.instantiation, object.param).toString());
    }

    @Override
    @Nullable
    protected CidrGoogleTestObject findTestObject(@NotNull Location location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationProducer", "findTestObject"));
        }
        PsiElement element = location.getPsiElement();
        if (location instanceof OCGoogleTestLocationProvider.OCGoogleTestLocation) {
            CidrGoogleTestObject object;
            OCGoogleTestLocationProvider.OCGoogleTestLocation gLocation = (OCGoogleTestLocationProvider.OCGoogleTestLocation)location;
            if (!(element instanceof OCStruct) && (object = CidrGoogleTestRunConfigurationProducer.findTestObject(element)) != null) {
                element = this.getElement(object);
            }
            if (element instanceof OCStruct) {
                return new CidrGoogleTestObject(gLocation.isSuiteOnly() ? CidrGoogleTestObject.KIND.SUITE : CidrGoogleTestObject.KIND.TEST, element, gLocation.getInstantiation(), gLocation.getParam());
            }
        }
        return CidrGoogleTestRunConfigurationProducer.findTestObject(element);
    }

    @Nullable
    private static CidrGoogleTestObject findTestObject(@NotNull PsiElement element) {
        OCSymbol owner;
        OCSymbolWithQualifiedName resolvedOwner;
        OCFunctionSymbol symbol;
        OCSymbol parentSymbol;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationProducer", "findTestObject"));
        }
        PsiElement parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCFunctionDefinition.class, OCStruct.class});
        if (parent instanceof OCStruct && (parentSymbol = ((OCStruct)parent).getSymbol()) != null && CidrTestUtil.isGoogleTestClass((OCStructSymbol)parentSymbol)) {
            return new CidrGoogleTestObject(CidrGoogleTestObject.KIND.TEST, parent);
        }
        if (parent instanceof OCFunctionDefinition && (symbol = ((OCFunctionDefinition)parent).getSymbol()) != null && (resolvedOwner = symbol.getResolvedOwner()) != null && (owner = resolvedOwner.getDefinitionSymbol()) instanceof OCStructSymbol && CidrTestUtil.isGoogleTestClass((OCStructSymbol)owner)) {
            OCStruct struct = (OCStruct)((OCStructSymbol)owner).locateDefinition();
            return struct == null ? null : new CidrGoogleTestObject(CidrGoogleTestObject.KIND.TEST, struct);
        }
        parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCMacroCall.class, OCFile.class});
        if (parent instanceof OCMacroCall) {
            Collection<OCStructSymbol> res;
            Couple<String> suite;
            List<OCMacroCallArgument> arguments;
            OCMacroCall gtestMacro = CidrTestUtil.findGoogleTestMacros(parent);
            if (gtestMacro != null && (arguments = gtestMacro.getArguments()).size() >= 2) {
                OCStruct targetElement;
                OCMacroCallArgument suiteArg = arguments.get(0);
                OCMacroCallArgument testArg = arguments.get(1);
                boolean isSuite = CidrGoogleTestRunConfigurationProducer.isFirstArgument(PsiTreeUtil.getParentOfType((PsiElement)element, OCMacroCallArgument.class)) || CidrGoogleTestRunConfigurationProducer.isFirstArgument(element.getPrevSibling());
                String suiteName = CidrTestUtil.extractArgumentValue(suiteArg);
                String testName = CidrTestUtil.extractArgumentValue(testArg);
                OCStructSymbol symbol2 = CidrTestUtil.findGoogleTestSymbol(element.getProject(), suiteName, testName);
                if (symbol2 != null && (targetElement = (OCStruct)symbol2.locateDefinition()) != null) {
                    return new CidrGoogleTestObject(isSuite ? CidrGoogleTestObject.KIND.SUITE : CidrGoogleTestObject.KIND.TEST, targetElement);
                }
            }
            if ((suite = CidrTestUtil.extractFullSuiteNameFromMacro(parent)) != null && (res = CidrTestUtil.findGoogleTestSymbolsForSuiteRandomly(element.getProject(), (String)suite.first, true)).size() != 0) {
                OCStruct struct = (OCStruct)res.iterator().next().locateDefinition();
                if (struct == null) {
                    return null;
                }
                return new CidrGoogleTestObject(CidrGoogleTestObject.KIND.SUITE, struct, (String)suite.second, null);
            }
        } else if (parent instanceof OCFile) {
            return new CidrGoogleTestObject(CidrGoogleTestObject.KIND.FILE, parent);
        }
        return null;
    }

    private static boolean isFirstArgument(@Nullable PsiElement element) {
        OCMacroCall macroCall = (OCMacroCall)PsiTreeUtil.getParentOfType((PsiElement)element, OCMacroCall.class);
        if (macroCall != null) {
            List<OCMacroCallArgument> arguments = macroCall.getArguments();
            return arguments.size() > 0 && arguments.get(0).equals(element);
        }
        return false;
    }

    @Override
    protected String formatTestName(CidrTestRunConfigurationProducer.Scope scope) {
        return scope.suite + "." + scope.test;
    }
}

