/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.google.common.collect.Maps;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTargetWithConfigurations;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrGoogleTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationEditor;
import com.jetbrains.cidr.execution.testing.CidrTestUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestRunConfigurationEditor<CONFIGURATION extends CidrRunConfiguration, BC extends CidrBuildConfiguration, TARGET extends CidrBuildTargetWithConfigurations<BC>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>>
extends CidrTestRunConfigurationEditor<CONFIGURATION, BC, TARGET, BCH> {
    private final NavigableMap<String, OCStructSymbol> myTestSymbols;
    private AtomicReference<String> myCollectingSuiteName;

    public CidrGoogleTestRunConfigurationEditor(@NotNull Project project, @NotNull BCH configHelper) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationEditor", "<init>"));
        }
        if (configHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configHelper", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationEditor", "<init>"));
        }
        super(project, configHelper);
        this.myTestSymbols = Maps.synchronizedNavigableMap(new TreeMap());
        this.myCollectingSuiteName = new AtomicReference();
    }

    @Override
    @NotNull
    protected JComponent createEditor() {
        this.myProject.putUserData(CidrGoogleTestRunConfigurationData.GOOGLE_TEST_LIGHTWEIGHT_VALIDATION, (Object)true);
        JComponent jComponent = super.createEditor();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationEditor", "createEditor"));
        }
        return jComponent;
    }

    @Override
    protected void disposeEditor() {
        this.myProject.putUserData(CidrGoogleTestRunConfigurationData.GOOGLE_TEST_LIGHTWEIGHT_VALIDATION, null);
        super.disposeEditor();
    }

    @Override
    @NotNull
    protected Condition<OCSymbol> getClassCompletionCondition() {
        Condition<OCSymbol> condition = new Condition<OCSymbol>(){

            public boolean value(OCSymbol symbol) {
                return symbol instanceof OCStructSymbol && CidrTestUtil.isGoogleTestClass((OCStructSymbol)symbol);
            }
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationEditor", "getClassCompletionCondition"));
        }
        return condition;
    }

    @Override
    @Nullable
    protected Function<OCSymbol, String> getClassCompletionNameMapper() {
        return new Function<OCSymbol, String>(){

            public String fun(OCSymbol symbol) {
                if (!(symbol instanceof OCStructSymbol)) {
                    return null;
                }
                Couple<String> pair = CidrTestUtil.extractGoogleTestName((OCStructSymbol)symbol);
                return pair == null ? null : (String)pair.first;
            }
        };
    }

    private boolean collectTestSymbols(final @NotNull Project project, final @NotNull String suiteName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationEditor", "collectTestSymbols"));
        }
        if (suiteName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteName", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationEditor", "collectTestSymbols"));
        }
        if (this.getAnySymbolForSuite(suiteName) != null) {
            return false;
        }
        String alreadyRunning = this.myCollectingSuiteName.getAndSet(suiteName);
        if (!suiteName.equals(alreadyRunning)) {
            final Runnable action = new Runnable(){

                @Override
                public void run() {
                    if (project.isDisposed()) {
                        return;
                    }
                    Collection<OCStructSymbol> symbols = CidrTestUtil.findGoogleTestSymbolsForSuiteSorted(project, suiteName);
                    Pattern simpleTestPattern = CidrTestUtil.getSimpleTestPattern(suiteName);
                    for (OCStructSymbol s : symbols) {
                        String name;
                        if (simpleTestPattern.matcher(s.getName()).matches()) {
                            name = s.getName();
                        } else {
                            Couple<String> res = CidrTestUtil.extractGoogleTestName(s);
                            CidrTestLog.LOG.assertTrue(res != null);
                            name = (String)res.first + "_" + (String)res.second + "_Test";
                        }
                        CidrGoogleTestRunConfigurationEditor.this.myTestSymbols.put(name, s);
                    }
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (suiteName.equals(CidrGoogleTestRunConfigurationEditor.this.getTestClassText())) {
                                CidrGoogleTestRunConfigurationEditor.this.updateClassAndMethodControls();
                            }
                        }
                    });
                }
            };
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode()) {
                app.runReadAction(action);
            } else {
                ProgressIndicatorUtils.scheduleWithWriteActionPriority(new ReadTask(){

                    @Override
                    public void computeInReadAction(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationEditor$4", "computeInReadAction"));
                        }
                        action.run();
                    }

                    @Override
                    public void onCanceled(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationEditor$4", "onCanceled"));
                        }
                        if (CidrGoogleTestRunConfigurationEditor.this.getAnySymbolForSuite(suiteName) == null) {
                            ProgressIndicatorUtils.scheduleWithWriteActionPriority(this);
                        }
                    }
                });
            }
        }
        return true;
    }

    @Override
    protected boolean isCompletionTopLevelOnly() {
        return false;
    }

    @Nullable
    private OCStructSymbol getAnySymbolForSuite(@NotNull String suiteName) {
        if (suiteName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteName", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationEditor", "getAnySymbolForSuite"));
        }
        String prefix = suiteName + "_";
        Map.Entry<String, OCStructSymbol> entry = this.myTestSymbols.ceilingEntry(prefix);
        return entry != null && entry.getKey().startsWith(prefix) ? entry.getValue() : null;
    }

    @Override
    protected boolean isValidClassName() {
        String className = this.getTestClassText();
        if (className == null || this.collectTestSymbols(this.myProject, className)) {
            return false;
        }
        OCStructSymbol symbol = this.getAnySymbolForSuite(className);
        return symbol != null && CidrTestUtil.googleTestNameMatches(symbol, className);
    }

    @Override
    @NotNull
    protected Set<String> collectClassMethods() {
        String className = this.getTestClassText();
        if (className == null || this.collectTestSymbols(this.myProject, className)) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationEditor", "collectClassMethods"));
            }
            return set;
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        String prefix = className + "_";
        for (Map.Entry<String, OCStructSymbol> each : this.myTestSymbols.tailMap(prefix).entrySet()) {
            if (!each.getKey().startsWith(prefix)) break;
            Couple<String> name = CidrTestUtil.extractGoogleTestName(each.getValue());
            if (name == null || !((String)name.getFirst()).equals(className)) continue;
            result2.add((String)name.second);
        }
        LinkedHashSet<String> linkedHashSet = result2;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationEditor", "collectClassMethods"));
        }
        return linkedHashSet;
    }

    @Override
    protected void updateClassAndMethodControls() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.updateClassAndMethodControls();
        if (!this.myProject.isDisposed()) {
            this.myProject.putUserData(CidrGoogleTestRunConfigurationData.GOOGLE_TEST_LIGHTWEIGHT_VALIDATION, null);
            this.myMethodCombo.fireSelectedItemChanged();
            this.myProject.putUserData(CidrGoogleTestRunConfigurationData.GOOGLE_TEST_LIGHTWEIGHT_VALIDATION, (Object)true);
        }
    }

    @Override
    @NotNull
    protected List<TARGET> getTargets() {
        List list = ContainerUtil.filter(this.myConfigHelper.getTargets(), (Condition)new Condition<TARGET>(){

            public boolean value(TARGET target) {
                return target.isExecutable();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrGoogleTestRunConfigurationEditor", "getTargets"));
        }
        return list;
    }

    @Override
    protected String getAllSuitesMessage() {
        return CidrBundle.message("gtest.allTestSuites", new Object[0]);
    }

    @Override
    protected String getAllSuitesTipMessage() {
        return CidrBundle.message("gtest.allTestSuitesTip", new Object[0]);
    }

    @Override
    protected String getTestNameMessage() {
        return CidrBundle.message("gtest.configuration.test", new Object[0]);
    }

    @Override
    protected String getSuiteNameMessage() {
        return CidrBundle.message("gtest.configuration.suite", new Object[0]);
    }

    @Override
    protected String getAllTestsMessage() {
        return CidrBundle.message("gtest.allTestsInSuite", new Object[0]);
    }
}

