/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectVariablesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrElementValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.TypeRenderer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueRenderer {
    public static final String ERROR = "error: ";
    @NotNull
    protected CidrPhysicalValue myValue;
    @NotNull
    protected final TypeRenderer myTypeRenderer;
    @Nullable
    private volatile String myDisplayStringCache;
    @Nullable
    private volatile Integer myChildrenCountCache;
    private int myRemainingChildrenCount;
    private int myCurrentChildrenCount;

    public ValueRenderer(@NotNull CidrPhysicalValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "<init>"));
        }
        this.myRemainingChildrenCount = -1;
        this.myCurrentChildrenCount = 0;
        this.myValue = value;
        this.myTypeRenderer = TypeRenderer.createRenderer(value);
    }

    public ValueRenderer(@NotNull CidrPhysicalValue value, @NotNull TypeRenderer typeRenderer) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "<init>"));
        }
        if (typeRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeRenderer", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "<init>"));
        }
        this.myRemainingChildrenCount = -1;
        this.myCurrentChildrenCount = 0;
        this.myValue = value;
        this.myTypeRenderer = typeRenderer;
    }

    @NotNull
    public CidrPhysicalValue getValue() {
        CidrPhysicalValue cidrPhysicalValue = this.myValue;
        if (cidrPhysicalValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "getValue"));
        }
        return cidrPhysicalValue;
    }

    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "getChildEvaluationExpression"));
        }
        boolean isPointer = this.myValue.getVar().isPointer();
        if (isPointer) {
            String string = this.getChildEvaluationExpression(child, "->", this.myValue);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "getChildEvaluationExpression"));
            }
            return string;
        }
        if (this.myValue instanceof CidrElementValue) {
            CidrElementValue value = (CidrElementValue)this.myValue;
            if (value.getIndex() == 0) {
                String string = this.getChildEvaluationExpression(child, "->", value.getContainer());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "getChildEvaluationExpression"));
                }
                return string;
            }
        } else if (this.myValue instanceof CidrMemberValue) {
            CidrPhysicalValue parent = ((CidrMemberValue)this.myValue).getParent();
            if (this.isSuperNode()) {
                String string = parent.getRenderer().getChildEvaluationExpression(child, lvalue);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "getChildEvaluationExpression"));
                }
                return string;
            }
        }
        String string = this.getChildEvaluationExpression(child, ".", this.myValue);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "getChildEvaluationExpression"));
        }
        return string;
    }

    private boolean isSuperNode() {
        LLValue var = this.myValue.getVar();
        return var.getType().equals(var.getName());
    }

    protected LLValue messageSendToSelf(String selectorAndArgs, EvaluationContext context) throws ExecutionException, DBCannotEvaluateException {
        return this.messageSendToSelf(selectorAndArgs, "id", context);
    }

    protected LLValue messageSendToSelf(String selectorAndArgs, String returnType, EvaluationContext context) throws ExecutionException, DBCannotEvaluateException {
        return context.messageSend(this.myValue.getVar(), selectorAndArgs, returnType);
    }

    protected boolean isSelfKindOfClass(String className, EvaluationContext context) throws ExecutionException, DBCannotEvaluateException {
        return context.isKindOfClass(className, this.getValue());
    }

    public Icon getIcon(boolean hasChildren, CidrPhysicalValue value) {
        return hasChildren ? AllIcons.Debugger.Value : AllIcons.Debugger.Db_primitive;
    }

    public StringBuilder getConsoleDescription(EvaluationContext context) throws ExecutionException, DBCannotEvaluateException, DBCannotCollectVariablesException {
        StringBuilder builder = new StringBuilder();
        builder.append("(").append(this.myValue.getType()).append(") ").append(this.computeValue(context));
        if (this.shouldPrintChildrenConsoleDescription()) {
            this.printChildrenConsoleDescription(context, builder);
        }
        return builder;
    }

    protected boolean shouldPrintChildrenConsoleDescription() {
        return !this.getValue().isNSObject();
    }

    protected void printChildrenConsoleDescription(EvaluationContext context, StringBuilder builder) throws ExecutionException, DBCannotCollectVariablesException, DBCannotEvaluateException {
        if (this.computeHasChildren(context)) {
            builder.append("\n{\n");
            try {
                this.computeChildren(context, new ConsoleDescriptionNode(builder, context));
            }
            catch (ExecutionRuntimeException e) {
                throw e.myException;
            }
            finally {
                builder.append("}");
            }
        }
    }

    protected static String demangledType(LLValue value) {
        return ValueRenderer.demangledType(value.getBestType());
    }

    protected static String demangledType(String type) {
        return StringUtil.replace((String)type, (String)"'", (String)"");
    }

    protected static long alignedOffset(long valueSize, long align) {
        return (valueSize + align - 1L) / align * align;
    }

    @NotNull
    public String getDisplayType() {
        String string = this.myTypeRenderer.getDisplayType();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "getDisplayType"));
        }
        return string;
    }

    protected String getChildEvaluationExpression(CidrPhysicalValue child, String s, CidrPhysicalValue parent) {
        String primeParentExpression = parent.getEvaluationExpression();
        String parentExpression = "((" + parent.getType() + ")(" + primeParentExpression + "))";
        return parentExpression + s + child.getVar().getName();
    }

    @NotNull
    public String computeValue(@NotNull EvaluationContext context) throws ExecutionException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "computeValue"));
        }
        if (this.myDisplayStringCache == null) {
            LLValue var = this.myValue.getVar();
            String value = var.isNilPointer() ? "nil" : this.doComputeValue(context);
            this.myDisplayStringCache = value.equals("{...}") ? "" : value;
        }
        String string = this.myDisplayStringCache != null ? this.myDisplayStringCache : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "computeValue"));
        }
        return string;
    }

    @NotNull
    protected String doComputeValue(@NotNull EvaluationContext context) throws ExecutionException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "doComputeValue"));
        }
        String string = this.myValue.getVar().getReadableValue();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "doComputeValue"));
        }
        return string;
    }

    public boolean computeHasChildren(@NotNull EvaluationContext context) throws ExecutionException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "computeHasChildren"));
        }
        return this.computeChildrenCount(context, 1) != 0;
    }

    protected int computeChildrenCount(@NotNull EvaluationContext context) throws ExecutionException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "computeChildrenCount"));
        }
        return this.computeChildrenCount(context, Integer.MAX_VALUE);
    }

    private int computeChildrenCount(@NotNull EvaluationContext context, int max) throws ExecutionException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "computeChildrenCount"));
        }
        if (this.myRemainingChildrenCount != 0) {
            try {
                this.myChildrenCountCache = this.myValue.getVar().isNilPointer() ? 0 : this.doComputeChildrenCount(context, max);
            }
            catch (DBCannotEvaluateException e) {
                CidrDebuggerLog.LOG.debug((Throwable)e);
                return 0;
            }
            catch (DBCannotCollectVariablesException e) {
                CidrDebuggerLog.LOG.debug((Throwable)e);
                return 0;
            }
        }
        return this.myChildrenCountCache;
    }

    protected int doComputeChildrenCount(@NotNull EvaluationContext context) throws ExecutionException, DBCannotEvaluateException, DBCannotCollectVariablesException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "doComputeChildrenCount"));
        }
        return this.doComputeChildrenCount(context, Integer.MAX_VALUE);
    }

    private int doComputeChildrenCount(@NotNull EvaluationContext context, int max) throws ExecutionException, DBCannotEvaluateException, DBCannotCollectVariablesException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "doComputeChildrenCount"));
        }
        return context.getChildrenCount(this.myValue.getVar(), max);
    }

    public void computeChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container) throws ExecutionException, DBCannotCollectVariablesException, DBCannotEvaluateException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "computeChildren"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "computeChildren"));
        }
        if (!this.computeHasChildren(context)) {
            container.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        this.doComputeChildren(context, container, false);
    }

    protected int getBatchSize() {
        return 50;
    }

    protected void doComputeChildren(@NotNull EvaluationContext context, XCompositeNode container, boolean modifiable) throws ExecutionException, DBCannotCollectVariablesException, DBCannotEvaluateException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer", "doComputeChildren"));
        }
        int batchSize = this.getBatchSize();
        int count = this.computeChildrenCount(context, this.myCurrentChildrenCount + batchSize + 1);
        if (count <= this.myCurrentChildrenCount) {
            return;
        }
        CidrValue.addAllTo(this.myValue.getProcess(), context, this.myValue.getSourcePosition(), this.myValue.getFrame(), context.getVariableChildrenRange(this.myValue.getVar(), this.myCurrentChildrenCount, batchSize), this.myValue, container, modifiable);
        this.myCurrentChildrenCount = Math.min(this.myCurrentChildrenCount + batchSize, count);
        this.myRemainingChildrenCount = count - this.myCurrentChildrenCount;
        if (this.myRemainingChildrenCount > 0) {
            container.tooManyChildren(-1);
        }
    }

    protected static Map<String, LLValue> sort(List<LLValue> values) {
        HashMap<String, LLValue> result2 = new HashMap<String, LLValue>();
        for (LLValue value : values) {
            result2.put(value.getName(), value);
        }
        return result2;
    }

    private static class ConsoleDescriptionNode
    implements XCompositeNode {
        private final StringBuilder myBuilder;
        private final EvaluationContext myContext;

        public ConsoleDescriptionNode(StringBuilder builder, EvaluationContext context) {
            this.myBuilder = builder;
            this.myContext = context;
        }

        public void addChildren(@NotNull XValueChildrenList children2, boolean last) {
            if (children2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer$ConsoleDescriptionNode", "addChildren"));
            }
            for (int i = 0; i < children2.size(); ++i) {
                String name = children2.getName(i);
                this.myBuilder.append("\t").append(name).append(" = ");
                try {
                    XValue value = children2.getValue(i);
                    StringBuilder childrenDesc = ((CidrValue)value).getConsoleDescription(this.myContext);
                    String shiftedChildren = childrenDesc.toString().replace("\n", "\n\t");
                    this.myBuilder.append(shiftedChildren);
                }
                catch (ExecutionException e) {
                    throw new ExecutionRuntimeException(e);
                }
                catch (DBCannotEvaluateException e) {
                    this.myBuilder.append(ValueRenderer.ERROR).append(e);
                }
                catch (DBCannotCollectVariablesException e) {
                    this.myBuilder.append(ValueRenderer.ERROR).append(e);
                }
                this.myBuilder.append("\n");
            }
        }

        public void tooManyChildren(int remaining) {
            this.myBuilder.append("\t...");
            if (remaining > 0) {
                this.myBuilder.append(remaining).append(" more\n");
            }
        }

        public void setErrorMessage(@NotNull String errorMessage) {
            if (errorMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer$ConsoleDescriptionNode", "setErrorMessage"));
            }
            this.myBuilder.append(ValueRenderer.ERROR).append(errorMessage);
        }

        public void setErrorMessage(@NotNull String errorMessage, @Nullable XDebuggerTreeNodeHyperlink link) {
            if (errorMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer$ConsoleDescriptionNode", "setErrorMessage"));
            }
            this.setErrorMessage(errorMessage);
        }

        public void setMessage(@NotNull String message, @Nullable Icon icon, @NotNull SimpleTextAttributes attributes, @Nullable XDebuggerTreeNodeHyperlink link) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer$ConsoleDescriptionNode", "setMessage"));
            }
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer$ConsoleDescriptionNode", "setMessage"));
            }
        }

        public boolean isObsolete() {
            return false;
        }

        public void setAlreadySorted(boolean alreadySorted) {
        }
    }

    static class ExecutionRuntimeException
    extends RuntimeException {
        ExecutionException myException;

        ExecutionRuntimeException(ExecutionException exception) {
            this.myException = exception;
        }
    }
}

