/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import org.jetbrains.annotations.NotNull;

public class TypeRenderer {
    @NotNull
    protected CidrPhysicalValue myValue;

    public TypeRenderer(@NotNull CidrPhysicalValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/TypeRenderer", "<init>"));
        }
        this.myValue = value;
    }

    @NotNull
    public String getDisplayType() {
        String string = this.myValue.getVar().getBestType();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/TypeRenderer", "getDisplayType"));
        }
        return string;
    }

    @NotNull
    public static TypeRenderer createRenderer(@NotNull CidrPhysicalValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/TypeRenderer", "createRenderer"));
        }
        TypeRenderer typeRenderer = new TypeRenderer(value);
        if (typeRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/TypeRenderer", "createRenderer"));
        }
        return typeRenderer;
    }

    @NotNull
    public static TypeRenderer createTemplateRenderer(@NotNull CidrPhysicalValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/TypeRenderer", "createTemplateRenderer"));
        }
        TemplateTypeRenderer templateTypeRenderer = new TemplateTypeRenderer(value);
        if (templateTypeRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/TypeRenderer", "createTemplateRenderer"));
        }
        return templateTypeRenderer;
    }

    @NotNull
    public static TypeRenderer createSelectorRenderer(@NotNull CidrPhysicalValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/TypeRenderer", "createSelectorRenderer"));
        }
        SelectorTypeRenderer selectorTypeRenderer = new SelectorTypeRenderer(value);
        if (selectorTypeRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/TypeRenderer", "createSelectorRenderer"));
        }
        return selectorTypeRenderer;
    }

    private static class SelectorTypeRenderer
    extends TypeRenderer {
        public SelectorTypeRenderer(@NotNull CidrPhysicalValue value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/TypeRenderer$SelectorTypeRenderer", "<init>"));
            }
            super(value);
        }

        @Override
        @NotNull
        public String getDisplayType() {
            if ("SEL" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/TypeRenderer$SelectorTypeRenderer", "getDisplayType"));
            }
            return "SEL";
        }
    }

    private static class TemplateTypeRenderer
    extends TypeRenderer {
        private static final int TEMPLATE_TYPE_REDUCE_LEVEL = 1;

        public TemplateTypeRenderer(@NotNull CidrPhysicalValue value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/TypeRenderer$TemplateTypeRenderer", "<init>"));
            }
            super(value);
        }

        @Override
        @NotNull
        public String getDisplayType() {
            String type = this.myValue.getVar().getBestType();
            StringBuilder result2 = new StringBuilder();
            int count = 0;
            for (int i = 0; i < type.length(); ++i) {
                char c = type.charAt(i);
                if (c == '<') {
                    ++count;
                }
                if (count <= 1) {
                    result2.append(c);
                }
                if (c != '>') continue;
                --count;
            }
            String string = count == 0 ? result2.toString() : type;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/TypeRenderer$TemplateTypeRenderer", "getDisplayType"));
            }
            return string;
        }
    }
}

