/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectVariablesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.TypeRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructValueRenderer
extends ValueRenderer {
    private final boolean mySupportsVariableChildReferencing;

    public StructValueRenderer(CidrPhysicalValue value, boolean supportsVariableChildReferencing) {
        super(value, TypeRenderer.createTemplateRenderer(value));
        this.mySupportsVariableChildReferencing = supportsVariableChildReferencing;
    }

    @Nullable
    public static ValueRenderer createIfStruct(@NotNull CidrPhysicalValue value, boolean supportsVariableChildReferencing, EvaluationContext context) throws ExecutionException {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/StructValueRenderer", "createIfStruct"));
        }
        return value.hasStructType(context) ? new StructValueRenderer(value, supportsVariableChildReferencing) : null;
    }

    @Override
    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/StructValueRenderer", "getChildEvaluationExpression"));
        }
        if (lvalue) {
            if (!this.mySupportsVariableChildReferencing) {
                String parentExpression = this.myValue.getEvaluationExpression(true);
                String string = parentExpression + "." + child.getVar().getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/StructValueRenderer", "getChildEvaluationExpression"));
                }
                return string;
            }
            String string = super.getChildEvaluationExpression(child, false);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/StructValueRenderer", "getChildEvaluationExpression"));
            }
            return string;
        }
        String string = super.getChildEvaluationExpression(child, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/StructValueRenderer", "getChildEvaluationExpression"));
        }
        return string;
    }

    @Override
    protected String getChildEvaluationExpression(CidrPhysicalValue child, String s, CidrPhysicalValue parent) {
        if (!this.mySupportsVariableChildReferencing) {
            String primeParentExpression = parent.getEvaluationExpression();
            String parentExpression = "((struct " + parent.getType() + ")(" + primeParentExpression + "))";
            return parentExpression + s + child.getVar().getName();
        }
        return super.getChildEvaluationExpression(child, s, parent);
    }

    @Override
    public void computeChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container) throws ExecutionException, DBCannotCollectVariablesException, DBCannotEvaluateException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/StructValueRenderer", "computeChildren"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/StructValueRenderer", "computeChildren"));
        }
        if (!this.computeHasChildren(context)) {
            container.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        this.doComputeChildren(context, container, true);
    }
}

