/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.TypeRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectorValueRenderer
extends ValueRenderer {
    public SelectorValueRenderer(@NotNull CidrPhysicalValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/SelectorValueRenderer", "<init>"));
        }
        super(value, TypeRenderer.createSelectorRenderer(value));
    }

    @Nullable
    public static ValueRenderer createIfSelector(@NotNull CidrPhysicalValue value, @NotNull LLValue var) {
        String type;
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/SelectorValueRenderer", "createIfSelector"));
        }
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/SelectorValueRenderer", "createIfSelector"));
        }
        SelectorValueRenderer result2 = null;
        if (var.isValidPointer() && SelectorValueRenderer.isSelectorType(type = var.getBestType())) {
            result2 = new SelectorValueRenderer(value);
        }
        return result2;
    }

    @Override
    @NotNull
    protected String doComputeValue(@NotNull EvaluationContext context) throws ExecutionException {
        String string;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/SelectorValueRenderer", "doComputeValue"));
        }
        try {
            string = context.getSelectorName(this.myValue.getVar());
        }
        catch (DBCannotEvaluateException e) {
            CidrDebuggerLog.LOG.debug((Throwable)e);
            String string2 = super.doComputeValue(context);
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/SelectorValueRenderer", "doComputeValue"));
            }
            return string2;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/SelectorValueRenderer", "doComputeValue"));
        }
        return string;
    }

    public static boolean isSelectorType(@NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/SelectorValueRenderer", "isSelectorType"));
        }
        return type.endsWith("objc_selector *") || type.equals("SEL");
    }
}

