/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectVariablesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrElementValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ContainerValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointerValueRenderer
extends ContainerValueRenderer {
    public PointerValueRenderer(CidrPhysicalValue cidrPhysicalValue) {
        super(cidrPhysicalValue);
    }

    @Nullable
    public static ValueRenderer createIfPointer(@NotNull CidrPhysicalValue value, @NotNull LLValue var) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/PointerValueRenderer", "createIfPointer"));
        }
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/PointerValueRenderer", "createIfPointer"));
        }
        if (!var.isValidPointer() || var.isPointerReference() || var.getTypeClass() == LLValue.TypeClass.FUNCTION || var.getBestType().equals("Swift.COpaquePointer") || var.getBestType().equals("Builtin.RawPointer") || value.isNSObject() || value.isCPPThis()) {
            return null;
        }
        return new PointerValueRenderer(value);
    }

    @Override
    protected int doComputeChildrenCount(@NotNull EvaluationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/PointerValueRenderer", "doComputeChildrenCount"));
        }
        if ("void *".equals(this.myValue.getVar().getBestType())) {
            return 0;
        }
        return 1;
    }

    @Override
    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/PointerValueRenderer", "getChildEvaluationExpression"));
        }
        int index = ((CidrElementValue)child).getIndex();
        String string = index == 0 ? "(*(" + this.myValue.getEvaluationExpression(lvalue) + "))" : this.evaluationExpressionForChildAtIndex(index, lvalue);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/PointerValueRenderer", "getChildEvaluationExpression"));
        }
        return string;
    }

    @Override
    protected boolean shouldPrintChildrenConsoleDescription() {
        return false;
    }

    @Override
    protected void doComputeChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container, boolean modifiable) throws ExecutionException, DBCannotEvaluateException, DBCannotCollectVariablesException {
        List<LLValue> arraySlice;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/PointerValueRenderer", "doComputeChildren"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/PointerValueRenderer", "doComputeChildren"));
        }
        int batchSize = this.getCurrentIndex() == 0 ? 1 : (this.getCurrentIndex() == 1 ? this.getBatchSize() - 1 : this.getBatchSize());
        try {
            arraySlice = context.arraySlice(this.myValue.getVar(), this.getCurrentIndex(), batchSize);
        }
        catch (DBCannotEvaluateException e) {
            CidrDebuggerLog.LOG.debug((Throwable)e);
            container.setErrorMessage(e.getMessage());
            return;
        }
        catch (DBCannotCollectVariablesException e) {
            CidrDebuggerLog.LOG.debug((Throwable)e);
            container.setErrorMessage(e.getMessage());
            return;
        }
        ArrayList<CidrValue> values = new ArrayList<CidrValue>();
        for (LLValue value : arraySlice) {
            values.add(this.nextElementValue(value, context));
        }
        CidrValue.addAllTo(values, container);
        container.tooManyChildren(-1);
    }

    private String evaluationExpressionForChildAtIndex(int index, boolean lvalue) {
        if (lvalue) {
            return "((" + this.myValue.getEvaluationExpression(true) + ") + " + index + ")";
        }
        return "(" + this.myValue.getEvaluationExpression() + ")[" + index + "]";
    }
}

