/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueModifier;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectVariablesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrModifiableMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValueModifier;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NSManagedObjectValueRenderer
extends ValueRenderer {
    private volatile LLValue myEntityCache;
    private final String myClassName;
    private final boolean mySwift;

    @Nullable
    public static NSManagedObjectValueRenderer create(CidrPhysicalValue value, EvaluationContext context) throws ExecutionException {
        try {
            return new NSManagedObjectValueRenderer(value, context);
        }
        catch (NotApplicableException e) {
            return null;
        }
        catch (DBCannotEvaluateException e) {
            return null;
        }
    }

    private NSManagedObjectValueRenderer(CidrPhysicalValue cidrPhysicalValue, EvaluationContext context) throws ExecutionException, DBCannotEvaluateException, NotApplicableException {
        super(cidrPhysicalValue);
        String type = this.myValue.getVar().getBestType();
        if (!this.myValue.isNSObject() && CidrDebuggerTypesHelper.unwrapSwiftOptionalType(type) == null) {
            throw new NotApplicableException();
        }
        CidrStackFrame.CachedTypeInfo typeInfo = context.getTypeInfo(type);
        Boolean isNSManagedObject = typeInfo.getNSManagedObject();
        if (isNSManagedObject == null) {
            isNSManagedObject = this.isSelfKindOfClass("NSManagedObject", context);
            typeInfo.setNSManagedObject(isNSManagedObject);
        }
        if (!isNSManagedObject.booleanValue()) {
            throw new NotApplicableException();
        }
        this.mySwift = this.myValue.getFrame().getFrame().getLanguage() == DebuggerDriver.StandardDebuggerLanguage.SWIFT;
        String className = context.stringFromNSString(context.messageSend(this.getEntity(context), "managedObjectClassName"));
        if (this.mySwift && !className.contains(".") && !this.isManagedObject(className)) {
            className = context.getSwiftClassName(this.myValue.getVar());
        }
        this.myClassName = className;
    }

    @Override
    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer", "getChildEvaluationExpression"));
        }
        if (this.mySwift) {
            boolean cast;
            StringBuilder sb = new StringBuilder();
            boolean bl = cast = !this.myClassName.equals(this.myValue.getType());
            if (cast) {
                sb.append('(');
            }
            sb.append(this.myValue.getEvaluationExpression());
            Boolean isNullable = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    String dynamicType = null;
                    if (NSManagedObjectValueRenderer.this.myValue instanceof CidrMemberValue && ((CidrMemberValue)NSManagedObjectValueRenderer.this.myValue).getParent().getRenderer() instanceof NSManagedObjectValueRenderer) {
                        dynamicType = ((NSManagedObjectValueRenderer)((CidrMemberValue)NSManagedObjectValueRenderer.this.myValue).getParent().getRenderer()).myClassName;
                    }
                    return NSManagedObjectValueRenderer.this.myValue.getProcess().getTypesHelper().isNullableType(NSManagedObjectValueRenderer.this.myValue, dynamicType);
                }
            });
            if (isNullable != null && isNullable.booleanValue()) {
                sb.append('!');
            }
            if (cast) {
                sb.append(" as! ").append(this.myClassName).append(')');
            }
            sb.append('.').append(child.getName());
            String string = sb.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer", "getChildEvaluationExpression"));
            }
            return string;
        }
        if (lvalue) {
            if (child instanceof KeyedValue) {
                String string = "(id)[" + this.myValue.getEvaluationExpression() + " valueForKey:@\"" + child.getName() + "\"]";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer", "getChildEvaluationExpression"));
                }
                return string;
            }
            String string = "(" + this.myValue.getEvaluationExpression(true) + ")->" + child.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer", "getChildEvaluationExpression"));
            }
            return string;
        }
        if (child instanceof KeyedValue) {
            String string = "(id)[" + this.myValue.getEvaluationExpression() + " " + child.getName() + "]";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer", "getChildEvaluationExpression"));
            }
            return string;
        }
        String string = "((" + this.myClassName + " *)(" + this.myValue.getEvaluationExpression() + "))->" + child.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer", "getChildEvaluationExpression"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayType() {
        String string = this.mySwift ? this.myClassName : this.myClassName + " *";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer", "getDisplayType"));
        }
        return string;
    }

    @Override
    public Icon getIcon(boolean hasChildren, CidrPhysicalValue value) {
        return AllIcons.Debugger.Db_db_object;
    }

    @Override
    @NotNull
    protected String doComputeValue(@NotNull EvaluationContext context) throws ExecutionException {
        String string;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer", "doComputeValue"));
        }
        try {
            LLValue entity = this.getEntity(context);
            String entityName = context.stringFromNSString(context.messageSend(entity, "name"));
            String objectID = context.objectDescription(context.messageSend(this.messageSendToSelf("objectID", context), "URIRepresentation"));
            string = "entity: " + entityName + (this.messageSendToSelf("isFault", "unsigned char", context).isTrue() ? "(Fault) " : " ") + objectID;
        }
        catch (DBCannotEvaluateException e) {
            CidrDebuggerLog.LOG.debug((Throwable)e);
            String string2 = super.doComputeValue(context);
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer", "doComputeValue"));
            }
            return string2;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer", "doComputeValue"));
        }
        return string;
    }

    @NotNull
    private LLValue getEntity(EvaluationContext context) throws ExecutionException, DBCannotEvaluateException {
        LLValue lLValue = this.myEntityCache != null ? this.myEntityCache : (this.myEntityCache = this.messageSendToSelf("entity", context));
        if (lLValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer", "getEntity"));
        }
        return lLValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doComputeChildren(@NotNull EvaluationContext context, XCompositeNode container, boolean modifiable) throws ExecutionException, DBCannotCollectVariablesException, DBCannotEvaluateException {
        LLValue key;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer", "doComputeChildren"));
        }
        LLValue entity = this.getEntity(context);
        LLValue attrDict = context.messageSend(entity, "attributesByName");
        LLValue attrKeys = context.messageSend(attrDict, "keyEnumerator");
        final String managedObjectClassName = this.myClassName;
        SmartList values = new SmartList();
        while ((key = context.messageSend(attrKeys, "nextObject")).isTrue()) {
            LLValue attrVal = this.messageSendToSelf("valueForKey:" + key.getPointer(), context);
            String name = context.stringFromNSString(key);
            attrVal.setName(name);
            values.add(new KeyedValue(context, attrVal, managedObjectClassName));
        }
        LLValue relDict = context.messageSend(entity, "relationshipsByName");
        LLValue relKeys = context.messageSend(relDict, "keyEnumerator");
        while ((key = context.messageSend(relKeys, "nextObject")).isTrue()) {
            LLValue relVal = this.messageSendToSelf("valueForKey:" + key.getPointer(), context);
            String name = context.stringFromNSString(key);
            relVal.setName(name);
            values.add(new KeyedValue(context, relVal, managedObjectClassName));
        }
        try {
            if (!this.isManagedObject(managedObjectClassName)) {
                LLValue intermediate;
                LLValue typed = this.mySwift ? context.evaluate(EvaluationContext.swiftCast(this.myValue.getVar().getPointer(), managedObjectClassName)) : context.evaluate(EvaluationContext.cast(this.myValue.getVar().getPointer(), managedObjectClassName + "*"));
                List<LLValue> children2 = context.getVariableChildren(typed);
                if (!children2.isEmpty() && typed.getType().equals(managedObjectClassName + "_" + managedObjectClassName + "_ *") && (intermediate = (LLValue)((Object)ContainerUtil.find(children2, (Condition)new Condition<LLValue>(){

                    public boolean value(LLValue child) {
                        return child.getName().equals(managedObjectClassName);
                    }
                }))) != null) {
                    children2 = context.getVariableChildren(intermediate);
                }
                for (LLValue child : children2) {
                    if (this.isManagedObject(child.getName())) continue;
                    values.add(new IVarValue(context, child, managedObjectClassName));
                }
            }
        }
        finally {
            CidrValue.addAllTo((Collection<CidrValue>)values, container);
        }
    }

    private boolean isManagedObject(String className) {
        return className.equals("NSManagedObject") || this.mySwift && className.equals("CoreData.NSManagedObject");
    }

    private static class NotApplicableException
    extends Exception {
        private NotApplicableException() {
        }
    }

    private static class KeyedValueModifier
    extends CidrValueModifier {
        public KeyedValueModifier(CidrStackFrame frame, KeyedValue value) {
            super(frame, value);
        }

        @Override
        protected void setValue(@NotNull String origExpr, @NotNull Pair<LLValue, String> valuePair, @NotNull XValueModifier.XModificationCallback callback, @NotNull DebuggerDriver driver) throws DBCannotEvaluateException, ExecutionException {
            if (origExpr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origExpr", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer$KeyedValueModifier", "setValue"));
            }
            if (valuePair == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuePair", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer$KeyedValueModifier", "setValue"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer$KeyedValueModifier", "setValue"));
            }
            if (driver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer$KeyedValueModifier", "setValue"));
            }
            EvaluationContext evaluationContext = this.getFrame().getProcess().getRendererFactory().createEvaluationContext(driver, null, this.getFrame());
            try {
                LLValue var = ((KeyedValue)this.getValue()).getParent().getVar();
                LLValue result2 = evaluationContext.messageSend(var, " setValue:((id)" + evaluationContext.convertToRValue(var, valuePair) + ") forKey:@\"" + this.getValue().getName() + "\"");
                if (result2.isNilPointer()) {
                    callback.errorOccurred(CidrDebuggerBundle.message("debug.assign.error.cannotAssignExpression", origExpr, this.getValue().getName()));
                    CidrDebuggerLog.LOG.debug("Cannot assign \"" + (String)valuePair.getSecond() + "\" to " + this.getValue().getName());
                    return;
                }
                callback.valueModified();
            }
            catch (ExecutionException e) {
                callback.errorOccurred(CidrDebuggerBundle.message("debug.assign.error.cannotAssignExpression", origExpr, this.getValue().getName()));
                CidrDebuggerLog.LOG.debug(e.getMessage());
            }
        }
    }

    private class KeyedValue
    extends IVarValue {
        public KeyedValue(EvaluationContext context, LLValue attrVal, String className) throws ExecutionException {
            super(context, attrVal, className);
        }

        @Override
        public XValueModifier getModifier() {
            return new KeyedValueModifier(this.getFrame(), this);
        }
    }

    private class IVarValue
    extends CidrModifiableMemberValue {
        private final String myClassName;

        public IVarValue(EvaluationContext context, LLValue attrVal, String className) throws ExecutionException {
            super(NSManagedObjectValueRenderer.this.myValue.getProcess(), context, NSManagedObjectValueRenderer.this.myValue.getSourcePosition(), NSManagedObjectValueRenderer.this.myValue.getFrame(), attrVal, NSManagedObjectValueRenderer.this.myValue);
            this.myClassName = className;
        }

        @Override
        protected XSourcePosition doComputePosition(@NotNull XSourcePosition position) {
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer$IVarValue", "doComputePosition"));
            }
            return NSManagedObjectValueRenderer.this.isManagedObject(this.myClassName) ? null : this.getProcess().getTypesHelper().resolveProperty(this, this.myClassName);
        }
    }
}

