/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectVariablesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.EnumerableCollectionValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NSCollectionValueRenderer
extends EnumerableCollectionValueRenderer {
    private boolean isDictionary;
    private LLValue myEnumerator;

    public NSCollectionValueRenderer(CidrPhysicalValue cidrPhysicalValue, EvaluationContext caster) {
        super(cidrPhysicalValue, caster);
    }

    @Nullable
    public static ValueRenderer createIfNSCollection(@NotNull EvaluationContext context, @NotNull CidrPhysicalValue value, @NotNull LLValue var) throws ExecutionException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSCollectionValueRenderer", "createIfNSCollection"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSCollectionValueRenderer", "createIfNSCollection"));
        }
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSCollectionValueRenderer", "createIfNSCollection"));
        }
        NSCollectionValueRenderer result2 = null;
        if (var.isValidPointer() && (value.isNSObject() || var.getBestType().equals("CFArrayRef") || var.getBestType().equals("CFDictionaryRef"))) {
            CidrStackFrame.CachedTypeInfo typeInfo = context.getTypeInfo(var.getBestType());
            Boolean isNSCollection = typeInfo.isNSCollection();
            if (isNSCollection == null) {
                try {
                    String id = EvaluationContext.cast(var.getPointer(), "id");
                    LLValue evaluated1 = context.evaluate(context.castIDToNumber("[" + id + " respondsToSelector: @selector(count)]", "int"), DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS);
                    LLValue evaluated2 = context.evaluate(context.castIDToNumber("[" + id + " respondsToSelector: @selector(objectEnumerator)]", "int"), DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS);
                    isNSCollection = evaluated1.isTrue() && evaluated2.isTrue();
                    typeInfo.setNSCollection(isNSCollection);
                }
                catch (DBCannotEvaluateException e) {
                    CidrDebuggerLog.LOG.debug((Throwable)e);
                }
            }
            if (isNSCollection != null && isNSCollection.booleanValue()) {
                result2 = new NSCollectionValueRenderer(value, context);
            }
        }
        return result2;
    }

    @Override
    protected int doComputeChildrenCount(@NotNull EvaluationContext context) throws DBCannotCollectVariablesException, ExecutionException, DBCannotEvaluateException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSCollectionValueRenderer", "doComputeChildrenCount"));
        }
        return (int)this.messageSendToSelf("count", "unsigned int", context).intValue();
    }

    @Override
    @Nullable
    protected CidrValue nextChild(EvaluationContext context) throws ExecutionException, DBCannotEvaluateException {
        CidrValue child;
        if (!this.myEnumerator.isValidPointer()) {
            return null;
        }
        LLValue next = context.messageSend(this.myEnumerator, "nextObject");
        if (this.isDictionary) {
            LLValue object = this.messageSendToSelf("objectForKey:" + EvaluationContext.cast(next.getPointer(), "id"), context);
            child = this.nextMapElementValue(context, next, object);
        } else {
            child = this.nextElementValue(next, context);
        }
        return child;
    }

    @Override
    protected void willExpand(EvaluationContext myCaster) throws ExecutionException, DBCannotCollectVariablesException, DBCannotEvaluateException {
        this.isDictionary = this.messageSendToSelf("respondsToSelector:@selector(keyEnumerator)", "unsigned char", myCaster).isTrue();
        this.myEnumerator = this.isDictionary ? myCaster.messageSend(this.myValue.getVar(), "keyEnumerator") : myCaster.messageSend(this.myValue.getVar(), "objectEnumerator");
    }

    @Override
    protected boolean shouldPrintChildrenConsoleDescription() {
        return true;
    }
}

