/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectVariablesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CollectionValueRenderer;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EnumerableCollectionValueRenderer
extends CollectionValueRenderer {
    private boolean myInitialized;

    public EnumerableCollectionValueRenderer(CidrPhysicalValue cidrPhysicalValue, EvaluationContext caster) {
        super(cidrPhysicalValue);
    }

    @Override
    protected final void doComputeChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container, boolean modifiable) throws ExecutionException, DBCannotCollectVariablesException, DBCannotEvaluateException {
        boolean tooMany;
        ArrayList<CidrValue> children2;
        int count;
        block9: {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/EnumerableCollectionValueRenderer", "doComputeChildren"));
            }
            if (container == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/EnumerableCollectionValueRenderer", "doComputeChildren"));
            }
            if (!this.myInitialized) {
                this.willExpand(context);
                this.myInitialized = true;
            }
            count = this.computeChildrenCount(context);
            children2 = new ArrayList<CidrValue>(this.getBatchSize());
            tooMany = false;
            do {
                if (container.isObsolete()) {
                    return;
                }
                CidrValue child = this.nextChild(context);
                if (child == null) break block9;
                children2.add(child);
                if (this.isCounted() && this.getCurrentIndex() == count) break block9;
            } while (this.getCurrentIndex() % this.getBatchSize() != 0);
            tooMany = true;
        }
        CidrValue.addAllTo(children2, container);
        if (this.isCounted()) {
            int remaining = count - this.getCurrentIndex();
            if (remaining > 0) {
                container.tooManyChildren(remaining);
            }
        } else if (tooMany) {
            container.tooManyChildren(-1);
        }
    }

    protected boolean isCounted() {
        return true;
    }

    @Nullable
    protected abstract CidrValue nextChild(EvaluationContext var1) throws ExecutionException, DBCannotCollectVariablesException, DBCannotEvaluateException;

    protected void willExpand(EvaluationContext myCaster) throws ExecutionException, DBCannotCollectVariablesException, DBCannotEvaluateException {
    }
}

