/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassValueRenderer
extends ValueRenderer {
    @Nullable
    public static ValueRenderer createIfClass(CidrPhysicalValue value, LLValue var) {
        return var.isValidPointer() && var.getBestType().equals("Class") ? new ClassValueRenderer(value) : null;
    }

    private ClassValueRenderer(CidrPhysicalValue value) {
        super(value);
    }

    @Override
    protected boolean shouldPrintChildrenConsoleDescription() {
        return false;
    }

    @Override
    @NotNull
    protected String doComputeValue(@NotNull EvaluationContext context) throws ExecutionException {
        String string;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ClassValueRenderer", "doComputeValue"));
        }
        try {
            string = context.getOCClassName(this.myValue.getVar());
        }
        catch (DBCannotEvaluateException e) {
            CidrDebuggerLog.LOG.debug((Throwable)e);
            String string2 = super.doComputeValue(context);
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ClassValueRenderer", "doComputeValue"));
            }
            return string2;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ClassValueRenderer", "doComputeValue"));
        }
        return string;
    }
}

