/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CFTypeValueRenderer
extends ValueRenderer {
    private static final Set<String> NOT_RENDER_AS_CFTYPE = ContainerUtil.newHashSet((Object[])new String[]{"CFArray", "CFDictionary", "CFSet", "CFString", "CFConstantString", "CFNumber"});
    private static final Pattern PATTERN = Pattern.compile("(^(__NS)?(CF[A-Z].*?)((Ref)|( \\*))$)|(^CoreFoundation\\.(CF[A-Z].*?)(Ref)?$)");

    @Nullable
    public static ValueRenderer createIfCFType(CidrPhysicalValue value, LLValue var) {
        if (!var.isValidPointer()) {
            return null;
        }
        String type = var.getBestType();
        Matcher m = PATTERN.matcher(type = CidrDebuggerTypesHelper.unwrapSwiftOptionalTypeIfNecessary(type));
        if (!m.matches()) {
            return null;
        }
        String collectionName = m.group(3) != null ? m.group(3) : m.group(8);
        return collectionName != null && !NOT_RENDER_AS_CFTYPE.contains(collectionName) ? new CFTypeValueRenderer(value) : null;
    }

    private CFTypeValueRenderer(CidrPhysicalValue value) {
        super(value);
    }

    @Override
    protected boolean shouldPrintChildrenConsoleDescription() {
        return false;
    }

    @Override
    @NotNull
    protected String doComputeValue(@NotNull EvaluationContext context) throws ExecutionException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/CFTypeValueRenderer", "doComputeValue"));
        }
        if (this.myValue.getVar().isValidPointer()) {
            String string;
            try {
                LLValue result2 = context.evaluate("(char *)[((id)CFCopyDescription(" + this.myValue.getVar().getPointer() + ")) UTF8String]", DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS);
                string = result2.getReadableValue();
            }
            catch (DBCannotEvaluateException e) {
                CidrDebuggerLog.LOG.debug((Throwable)e);
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/CFTypeValueRenderer", "doComputeValue"));
            }
            return string;
        }
        String string = super.doComputeValue(context);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/CFTypeValueRenderer", "doComputeValue"));
        }
        return string;
    }
}

