/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Expirable;
import com.intellij.util.PlatformUtils;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CustomValueRendererFactory;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CArrayValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CFTypeValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ClassValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.InvalidValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.NSCollectionValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.NSManagedObjectValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.NSObjectValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.PointerValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.SelectorValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.StructValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ValueRendererFactory {
    @NotNull
    public ValueRenderer createValueRenderer(@NotNull EvaluationContext evaluationContext, @NotNull CidrPhysicalValue value) throws ExecutionException {
        ValueRenderer result2;
        boolean isRenderersEnabled;
        if (evaluationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationContext", "com/jetbrains/cidr/execution/debugger/evaluation/ValueRendererFactory", "createValueRenderer"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/ValueRendererFactory", "createValueRenderer"));
        }
        LLValue var = value.getVar();
        if (!var.isValid()) {
            InvalidValueRenderer invalidValueRenderer = new InvalidValueRenderer(value);
            if (invalidValueRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/ValueRendererFactory", "createValueRenderer"));
            }
            return invalidValueRenderer;
        }
        CidrDebuggerSettings settings = CidrDebuggerSettings.getInstance();
        boolean bl = isRenderersEnabled = !PlatformUtils.isCLion() && settings.RENDERERS_ENABLED;
        if (isRenderersEnabled) {
            for (CustomValueRendererFactory factory : (CustomValueRendererFactory[])CustomValueRendererFactory.EP_NAME.getExtensions()) {
                result2 = factory.createRenderer(value, var, evaluationContext);
                if (result2 == null) continue;
                ValueRenderer valueRenderer = result2;
                if (valueRenderer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/ValueRendererFactory", "createValueRenderer"));
                }
                return valueRenderer;
            }
            if (settings.COCOA_RENDERERS_ENABLED && this.supportsCocoa() && (result2 = this.createOCRenderers(evaluationContext, value, settings.CORE_DATA_RENDERERS_ENABLED)) != null) {
                ValueRenderer valueRenderer = result2;
                if (valueRenderer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/ValueRendererFactory", "createValueRenderer"));
                }
                return valueRenderer;
            }
        }
        if ((result2 = this.createCRenderers(evaluationContext, value)) != null) {
            ValueRenderer valueRenderer = result2;
            if (valueRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/ValueRendererFactory", "createValueRenderer"));
            }
            return valueRenderer;
        }
        ValueRenderer valueRenderer = new ValueRenderer(value);
        if (valueRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/ValueRendererFactory", "createValueRenderer"));
        }
        return valueRenderer;
    }

    @Nullable
    protected ValueRenderer createOCRenderers(@NotNull EvaluationContext evaluationContext, @NotNull CidrPhysicalValue value, boolean createCoreDataRenderers) throws ExecutionException {
        if (evaluationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationContext", "com/jetbrains/cidr/execution/debugger/evaluation/ValueRendererFactory", "createOCRenderers"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/ValueRendererFactory", "createOCRenderers"));
        }
        LLValue var = value.getVar();
        ValueRenderer result2 = CFTypeValueRenderer.createIfCFType(value, var);
        if (result2 != null) {
            return result2;
        }
        result2 = NSCollectionValueRenderer.createIfNSCollection(evaluationContext, value, var);
        if (result2 != null) {
            return result2;
        }
        result2 = ClassValueRenderer.createIfClass(value, var);
        if (result2 != null) {
            return result2;
        }
        if (createCoreDataRenderers && (result2 = NSManagedObjectValueRenderer.create(value, evaluationContext)) != null) {
            return result2;
        }
        result2 = SelectorValueRenderer.createIfSelector(value, var);
        if (result2 != null) {
            return result2;
        }
        return NSObjectValueRenderer.createIfObject(value, var);
    }

    @Nullable
    protected ValueRenderer createCRenderers(@NotNull EvaluationContext evaluationContext, @NotNull CidrPhysicalValue value) throws ExecutionException {
        if (evaluationContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationContext", "com/jetbrains/cidr/execution/debugger/evaluation/ValueRendererFactory", "createCRenderers"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/evaluation/ValueRendererFactory", "createCRenderers"));
        }
        LLValue var = value.getVar();
        ValueRenderer result2 = CArrayValueRenderer.createIfCArray(value, var, this.printArrayDisplayString());
        if (result2 != null) {
            return result2;
        }
        result2 = PointerValueRenderer.createIfPointer(value, var);
        if (result2 != null) {
            return result2;
        }
        result2 = StructValueRenderer.createIfStruct(value, this.supportsVariableChildReferencing(), evaluationContext);
        return result2;
    }

    public abstract EvaluationContext createEvaluationContext(@NotNull DebuggerDriver var1, @Nullable Expirable var2, @NotNull CidrStackFrame var3);

    protected boolean supportsCocoa() {
        return false;
    }

    protected boolean printArrayDisplayString() {
        return false;
    }

    protected boolean supportsVariableChildReferencing() {
        return true;
    }

    @Deprecated
    public boolean supportsArrayEvaluation() {
        return false;
    }

    @Deprecated
    public boolean isCodeFragmentEvaluationSupported() {
        return false;
    }
}

