/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectVariablesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.XValueNodeExpirable;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrPhysicalValue
extends CidrValue {
    @NotNull
    protected final LLValue myVar;
    @NotNull
    protected final ValueRenderer myRenderer;

    public CidrPhysicalValue(@NotNull CidrDebugProcess process, @NotNull EvaluationContext context, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame, @NotNull LLValue var) throws ExecutionException {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue", "<init>"));
        }
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue", "<init>"));
        }
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue", "<init>"));
        }
        this(process, context, position, frame, var, var.getName());
    }

    public CidrPhysicalValue(@NotNull CidrDebugProcess process, @NotNull EvaluationContext context, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame, @NotNull LLValue var, @NotNull String displayName) throws ExecutionException {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue", "<init>"));
        }
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue", "<init>"));
        }
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue", "<init>"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue", "<init>"));
        }
        super(process, position, displayName, frame);
        this.myVar = var;
        this.myRenderer = this.myRenderersFactory.createValueRenderer(context, this);
    }

    @NotNull
    public ValueRenderer getRenderer() {
        ValueRenderer valueRenderer = this.myRenderer;
        if (valueRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue", "getRenderer"));
        }
        return valueRenderer;
    }

    @Override
    @NotNull
    public String getEvaluationExpression(boolean lvalue) {
        String string = this.myVar.getReferenceExpression();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue", "getEvaluationExpression"));
        }
        return string;
    }

    @NotNull
    public LLValue getVar() {
        LLValue lLValue = this.myVar;
        if (lLValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue", "getVar"));
        }
        return lLValue;
    }

    public String getType() {
        return this.myVar.getBestType();
    }

    @Override
    @NotNull
    protected CidrValue.PresentationData doComputePresentation(@NotNull EvaluationContext context) throws ExecutionException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue", "doComputePresentation"));
        }
        String type = this.myRenderer.getDisplayType();
        boolean hasChildren = this.doComputeHasChildren(context);
        Icon icon = this.myRenderer.getIcon(hasChildren, this);
        if (this.myVar.isPointer() && this.myProcess.getProject().getUserData(DO_NOT_SHOW_ADDRESSES) != Boolean.TRUE) {
            type = type + " | " + this.myVar.getReadablePointer();
        }
        CidrValue.PresentationData presentationData = new CidrValue.PresentationData(icon, type, this.myRenderer.computeValue(context), hasChildren);
        if (presentationData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue", "doComputePresentation"));
        }
        return presentationData;
    }

    private boolean doComputeHasChildren(EvaluationContext context) throws ExecutionException {
        return this.hasStructType(context) || this.myRenderer.computeHasChildren(context);
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue", "computeChildren"));
        }
        this.myProcess.postCommand(new CidrDebugProcess.DebuggerImplicitCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                if (driver == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue$1", "run"));
                }
                EvaluationContext context = CidrPhysicalValue.this.getContext(driver, new XValueNodeExpirable((Obsolescent)node));
                if (node.isObsolete()) {
                    return;
                }
                try {
                    CidrPhysicalValue.this.myRenderer.computeChildren(context, node);
                }
                catch (DBCannotCollectVariablesException e) {
                    CidrDebuggerLog.LOG.debug((Throwable)e);
                    node.setErrorMessage(e.getMessage());
                }
                catch (DBCannotEvaluateException e) {
                    CidrDebuggerLog.LOG.debug((Throwable)e);
                    node.setErrorMessage(e.getMessage());
                }
            }
        });
    }

    public boolean hasStructType(EvaluationContext context) throws ExecutionException {
        CidrDebuggerTypesHelper typesHelper = this.getTypesHelper();
        return typesHelper.hasStructType(this, context);
    }

    public boolean isNSObject() {
        return this.getVar().isNSObject();
    }

    public String toString() {
        return this.getVar().toString();
    }

    @Override
    @NotNull
    public StringBuilder getConsoleDescription(EvaluationContext context) throws ExecutionException, DBCannotEvaluateException, DBCannotCollectVariablesException {
        StringBuilder stringBuilder = this.myRenderer.getConsoleDescription(context);
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue", "getConsoleDescription"));
        }
        return stringBuilder;
    }

    @NotNull
    public CidrDebuggerTypesHelper getTypesHelper() {
        CidrDebuggerTypesHelper cidrDebuggerTypesHelper = this.getProcess().getTypesHelper();
        if (cidrDebuggerTypesHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue", "getTypesHelper"));
        }
        return cidrDebuggerTypesHelper;
    }

    public boolean isCPPThis() {
        if (this.myVar.getName().equals("this")) {
            CidrDebuggerTypesHelper typesHelper = this.getTypesHelper();
            return typesHelper.isCPPThisPsi(this);
        }
        return false;
    }
}

