/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrElementValue
extends CidrPhysicalValue {
    @NotNull
    private final CidrPhysicalValue myContainer;
    private int myIndex;

    public CidrElementValue(@NotNull CidrDebugProcess process, @NotNull EvaluationContext driver, @Nullable XSourcePosition position, @NotNull CidrPhysicalValue container, @NotNull LLValue object, String displayName) throws ExecutionException {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/jetbrains/cidr/execution/debugger/evaluation/CidrElementValue", "<init>"));
        }
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/jetbrains/cidr/execution/debugger/evaluation/CidrElementValue", "<init>"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/jetbrains/cidr/execution/debugger/evaluation/CidrElementValue", "<init>"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/jetbrains/cidr/execution/debugger/evaluation/CidrElementValue", "<init>"));
        }
        this(process, driver, position, container, object, displayName, -1);
    }

    public CidrElementValue(@NotNull CidrDebugProcess process, @NotNull EvaluationContext driver, @Nullable XSourcePosition position, @NotNull CidrPhysicalValue container, @NotNull LLValue var, @NotNull String displayName, int index) throws ExecutionException {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/jetbrains/cidr/execution/debugger/evaluation/CidrElementValue", "<init>"));
        }
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/jetbrains/cidr/execution/debugger/evaluation/CidrElementValue", "<init>"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/jetbrains/cidr/execution/debugger/evaluation/CidrElementValue", "<init>"));
        }
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/jetbrains/cidr/execution/debugger/evaluation/CidrElementValue", "<init>"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/jetbrains/cidr/execution/debugger/evaluation/CidrElementValue", "<init>"));
        }
        super(process, driver, position, container.getFrame(), var, displayName);
        this.myContainer = container;
        this.myIndex = index;
    }

    public int getIndex() {
        return this.myIndex;
    }

    @NotNull
    public CidrPhysicalValue getContainer() {
        CidrPhysicalValue cidrPhysicalValue = this.myContainer;
        if (cidrPhysicalValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrElementValue", "getContainer"));
        }
        return cidrPhysicalValue;
    }

    @Override
    @NotNull
    public String getEvaluationExpression(boolean lvalue) {
        String string = this.myContainer.myRenderer.getChildEvaluationExpression(this, lvalue);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrElementValue", "getEvaluationExpression"));
        }
        return string;
    }

    @Override
    protected XSourcePosition doComputePosition(@NotNull XSourcePosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/cidr/execution/debugger/evaluation/CidrElementValue", "doComputePosition"));
        }
        return this.myContainer.doComputePosition(position);
    }
}

