/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectVariablesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrElementValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import org.jetbrains.annotations.NotNull;

public class CidrDictionaryEntryValue
extends CidrValue {
    @NotNull
    private final CidrPhysicalValue myContainer;
    @NotNull
    private final CidrPhysicalValue myKey;
    @NotNull
    private final CidrPhysicalValue myObject;

    public CidrDictionaryEntryValue(@NotNull CidrDebugProcess process, @NotNull EvaluationContext driver, @NotNull CidrPhysicalValue container, @NotNull String displayName, @NotNull LLValue key, @NotNull LLValue object) throws ExecutionException {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/jetbrains/cidr/execution/debugger/evaluation/CidrDictionaryEntryValue", "<init>"));
        }
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/jetbrains/cidr/execution/debugger/evaluation/CidrDictionaryEntryValue", "<init>"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/jetbrains/cidr/execution/debugger/evaluation/CidrDictionaryEntryValue", "<init>"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/jetbrains/cidr/execution/debugger/evaluation/CidrDictionaryEntryValue", "<init>"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/cidr/execution/debugger/evaluation/CidrDictionaryEntryValue", "<init>"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/jetbrains/cidr/execution/debugger/evaluation/CidrDictionaryEntryValue", "<init>"));
        }
        super(process, container.getSourcePosition(), displayName, container.getFrame());
        this.myContainer = container;
        this.myKey = new CidrElementValue(process, driver, this.myPosition, container, key, "key");
        this.myObject = new CidrElementValue(process, driver, this.myPosition, container, object, "object");
    }

    @Override
    protected XSourcePosition doComputePosition(@NotNull XSourcePosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/cidr/execution/debugger/evaluation/CidrDictionaryEntryValue", "doComputePosition"));
        }
        return this.myContainer.doComputePosition(position);
    }

    @Override
    @NotNull
    public String getEvaluationExpression(boolean lvalue) {
        String string = this.myObject.getEvaluationExpression(lvalue);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrDictionaryEntryValue", "getEvaluationExpression"));
        }
        return string;
    }

    @Override
    @NotNull
    protected CidrValue.PresentationData doComputePresentation(@NotNull EvaluationContext myCaster) throws ExecutionException {
        if (myCaster == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myCaster", "com/jetbrains/cidr/execution/debugger/evaluation/CidrDictionaryEntryValue", "doComputePresentation"));
        }
        String keyValue = this.myKey.myRenderer.computeValue(myCaster);
        String objectValue = this.myObject.myRenderer.computeValue(myCaster);
        CidrValue.PresentationData presentationData = new CidrValue.PresentationData(AllIcons.Debugger.Value, null, keyValue + " -> " + objectValue, true);
        if (presentationData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrDictionaryEntryValue", "doComputePresentation"));
        }
        return presentationData;
    }

    @Override
    @NotNull
    public StringBuilder getConsoleDescription(EvaluationContext context) throws ExecutionException, DBCannotEvaluateException, DBCannotCollectVariablesException {
        StringBuilder stringBuilder = this.myKey.getConsoleDescription(context).append("   ->   ").append((CharSequence)this.myObject.getConsoleDescription(context));
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/CidrDictionaryEntryValue", "getConsoleDescription"));
        }
        return stringBuilder;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/execution/debugger/evaluation/CidrDictionaryEntryValue", "computeChildren"));
        }
        if (node.isObsolete()) {
            return;
        }
        XValueChildrenList values = new XValueChildrenList(2);
        values.add((XNamedValue)this.myKey);
        values.add((XNamedValue)this.myObject);
        node.addChildren(values, true);
    }
}

