/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLanguageSupportFactory;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointPropertiesPanel;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrSymbolicBreakpointType
extends XBreakpointType<XBreakpoint<Properties>, Properties> {
    public CidrSymbolicBreakpointType(String id) {
        this(id, "Symbolic Breakpoints");
    }

    protected CidrSymbolicBreakpointType(String id, String title) {
        super(id, title);
    }

    public String getDisplayText(XBreakpoint<Properties> breakpoint) {
        String result2;
        Properties properties = (Properties)breakpoint.getProperties();
        if (properties == null) {
            return "Invalid breakpoint";
        }
        String string = result2 = StringUtil.isEmpty((String)properties.getSymbolPattern()) ? "<Empty>" : properties.getSymbolPattern();
        if (properties.getModuleName() != null) {
            result2 = properties.getModuleName() + ": " + result2;
        }
        return result2;
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_method_breakpoint;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointType", "getEnabledIcon"));
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_method_breakpoint;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointType", "getDisabledIcon"));
        }
        return icon;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        Icon icon = AllIcons.Debugger.Db_dep_method_breakpoint;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointType", "getInactiveDependentIcon"));
        }
        return icon;
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    @Nullable
    public Properties createProperties() {
        return new Properties();
    }

    @NotNull
    public XBreakpoint<Properties> addBreakpoint(final Project project, JComponent parentComponent) {
        XBreakpoint xBreakpoint = (XBreakpoint)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<XBreakpoint<Properties>>(){

            public XBreakpoint<Properties> compute() {
                return XDebuggerManager.getInstance((Project)project).getBreakpointManager().addBreakpoint((XBreakpointType)CidrSymbolicBreakpointType.this, (XBreakpointProperties)new Properties());
            }
        });
        if (xBreakpoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointType", "addBreakpoint"));
        }
        return xBreakpoint;
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XBreakpoint<Properties>> createCustomTopPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointType", "createCustomTopPropertiesPanel"));
        }
        return this.createSymbolicBreakpointPropertiesPanel(project);
    }

    protected abstract CidrSymbolicBreakpointPropertiesPanel createSymbolicBreakpointPropertiesPanel(@NotNull Project var1);

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XBreakpoint<Properties> breakpoint, @NotNull Project project) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointType", "getEditorsProvider"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointType", "getEditorsProvider"));
        }
        return CidrDebuggerLanguageSupportFactory.getEditorsProvider(breakpoint);
    }

    public static class Properties
    extends XBreakpointProperties<Properties> {
        @Nullable
        private String mySymbolPattern;
        @Nullable
        private String myModuleName;

        public Properties() {
        }

        public Properties(@Nullable String symbolPattern, @Nullable String moduleName) {
            this.mySymbolPattern = symbolPattern;
            this.myModuleName = moduleName;
        }

        @Nullable
        public String getSymbolPattern() {
            return this.mySymbolPattern;
        }

        public void setSymbolPattern(@Nullable String symbolPattern) {
            this.mySymbolPattern = symbolPattern;
        }

        @Nullable
        public String getModuleName() {
            return this.myModuleName;
        }

        public void setModuleName(@Nullable String moduleName) {
            this.myModuleName = moduleName;
        }

        @NotNull
        public Properties getState() {
            Properties properties = this;
            if (properties == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointType$Properties", "getState"));
            }
            return properties;
        }

        public void loadState(@NotNull Properties state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointType$Properties", "loadState"));
            }
            this.mySymbolPattern = state.mySymbolPattern;
            this.myModuleName = state.myModuleName;
        }
    }
}

