/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotSetBreakpointException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCodePointHandlerBase;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CidrSymbolicBreakpointHandler
extends CidrCodePointHandlerBase<XBreakpoint<CidrSymbolicBreakpointType.Properties>> {
    public CidrSymbolicBreakpointHandler(CidrDebugProcess process, @NotNull Class<? extends XBreakpointType<XBreakpoint<CidrSymbolicBreakpointType.Properties>, ?>> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointHandler", "<init>"));
        }
        super(process, type);
    }

    @Override
    @NotNull
    protected Collection<LLCodepoint> doAddCodepoints(@NotNull DebuggerDriver driver, @NotNull XBreakpoint<CidrSymbolicBreakpointType.Properties> breakpoint, int threadId, int frameNumber) throws ExecutionException {
        List<LLCodepoint> list;
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointHandler", "doAddCodepoints"));
        }
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointHandler", "doAddCodepoints"));
        }
        String condition = this.convertCondition(breakpoint);
        CidrSymbolicBreakpointType.Properties properties = (CidrSymbolicBreakpointType.Properties)breakpoint.getProperties();
        if (properties == null || properties.getSymbolPattern() == null) {
            List<LLCodepoint> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointHandler", "doAddCodepoints"));
            }
            return list2;
        }
        try {
            list = Arrays.asList(driver.addSymbolicBreakpoint(properties.getSymbolPattern(), properties.getModuleName(), condition));
        }
        catch (DBCannotSetBreakpointException e) {
            List<LLCodepoint> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointHandler", "doAddCodepoints"));
            }
            return list3;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointHandler", "doAddCodepoints"));
        }
        return list;
    }
}

