/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.WriteAction;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrEvaluatorHelper;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrCodePointHandlerBase<T extends XBreakpoint<?>>
extends XBreakpointHandler<T> {
    protected final CidrDebugProcess myProcess;
    private final Map<T, List<LLCodepoint>> myBreakpoints;
    private final Map<Integer, T> myIdToBreakpoint;

    public CidrCodePointHandlerBase(CidrDebugProcess process, @NotNull Class<? extends XBreakpointType<T, ?>> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrCodePointHandlerBase", "<init>"));
        }
        super(type);
        this.myBreakpoints = new FactoryMap<T, List<LLCodepoint>>(){

            @Nullable
            protected List<LLCodepoint> create(T key) {
                return new ArrayList<LLCodepoint>();
            }
        };
        this.myIdToBreakpoint = new THashMap();
        this.myProcess = process;
    }

    public void registerBreakpoint(@NotNull T breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrCodePointHandlerBase", "registerBreakpoint"));
        }
        int threadId = this.myProcess.getCurrentThreadId();
        int frameNumber = this.myProcess.getCurrentFrameNumber();
        this.myProcess.postCommand(new CidrDebugProcess.DebuggerCommand((XBreakpoint)breakpoint, threadId, frameNumber){
            final /* synthetic */ XBreakpoint val$breakpoint;
            final /* synthetic */ int val$threadId;
            final /* synthetic */ int val$frameNumber;
            {
                this.val$breakpoint = xBreakpoint;
                this.val$threadId = n;
                this.val$frameNumber = n2;
            }

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                if (driver == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrCodePointHandlerBase$2", "run"));
                }
                CidrCodePointHandlerBase.this.doRegisterBreakpoint(driver, this.val$breakpoint, this.val$threadId, this.val$frameNumber);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRegisterBreakpoint(DebuggerDriver driver, T breakpoint, int threadId, int frameNumber) throws ExecutionException {
        Collection<LLCodepoint> added = this.doAddCodepoints(driver, breakpoint, threadId, frameNumber);
        if (added.isEmpty()) {
            return;
        }
        Map<T, List<LLCodepoint>> map = this.myBreakpoints;
        synchronized (map) {
            this.myBreakpoints.get(breakpoint).addAll(added);
            for (LLCodepoint each : added) {
                int id = each.getId();
                this.myIdToBreakpoint.put(id, breakpoint);
            }
        }
    }

    protected abstract Collection<LLCodepoint> doAddCodepoints(DebuggerDriver var1, T var2, int var3, int var4) throws ExecutionException;

    public void unregisterBreakpoint(@NotNull T breakpoint, boolean temporary) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrCodePointHandlerBase", "unregisterBreakpoint"));
        }
        this.myProcess.postCommand(new CidrDebugProcess.DebuggerCommand((XBreakpoint)breakpoint){
            final /* synthetic */ XBreakpoint val$breakpoint;
            {
                this.val$breakpoint = xBreakpoint;
            }

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                if (driver == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrCodePointHandlerBase$3", "run"));
                }
                CidrCodePointHandlerBase.this.doUnregisterBreakpoint(driver, this.val$breakpoint);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Integer> doUnregisterBreakpoint(T breakpoint) {
        List idsToRemove;
        Map<T, List<LLCodepoint>> map = this.myBreakpoints;
        synchronized (map) {
            List<LLCodepoint> removed = this.myBreakpoints.remove(breakpoint);
            if (removed == null) {
                return Collections.emptyList();
            }
            idsToRemove = ContainerUtil.map(removed, (Function)new Function<LLCodepoint, Integer>(){

                public Integer fun(LLCodepoint codepoint) {
                    return codepoint.getId();
                }
            });
            for (Integer each : idsToRemove) {
                this.myIdToBreakpoint.remove(each);
            }
        }
        return Collections.unmodifiableList(idsToRemove);
    }

    protected void doUnregisterBreakpoint(@NotNull DebuggerDriver driver, T breakpoint) throws ExecutionException {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrCodePointHandlerBase", "doUnregisterBreakpoint"));
        }
        List<Integer> idsToRemove = this.doUnregisterBreakpoint(breakpoint);
        if (!idsToRemove.isEmpty()) {
            this.removeBreakpointInBackend(driver, idsToRemove, breakpoint);
        }
    }

    protected void removeBreakpointInBackend(DebuggerDriver driver, List<Integer> ids, T breakpoint) throws ExecutionException {
        driver.removeCodepoints(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getCodepoint(int id) {
        Map<T, List<LLCodepoint>> map = this.myBreakpoints;
        synchronized (map) {
            return (T)((XBreakpoint)this.myIdToBreakpoint.get(id));
        }
    }

    @Nullable
    protected String convertCondition(final XBreakpoint<? extends XBreakpointProperties> breakpoint) {
        RunResult result2;
        String conversion;
        if (breakpoint.getCondition() != null && (conversion = (String)(result2 = new WriteAction<String>(){

            protected void run(@NotNull Result<String> stringResult) throws Throwable {
                block3: {
                    if (stringResult == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringResult", "com/jetbrains/cidr/execution/debugger/breakpoints/CidrCodePointHandlerBase$5", "run"));
                    }
                    try {
                        stringResult.setResult((Object)CidrEvaluatorHelper.getInstance().convertExpression(CidrCodePointHandlerBase.this.myProcess, breakpoint.getCondition(), breakpoint.getSourcePosition()));
                    }
                    catch (CidrEvaluatorHelper.ConversionException e) {
                        if (!(breakpoint instanceof XLineBreakpoint)) break block3;
                        CidrCodePointHandlerBase.this.myProcess.getSession().updateBreakpointPresentation((XLineBreakpoint)breakpoint, AllIcons.Debugger.Db_invalid_breakpoint, e.getMessage());
                    }
                }
            }
        }.execute()).getResultObject()) != null) {
            return conversion;
        }
        return breakpoint.getCondition();
    }
}

