/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.google.protobuf.GeneratedMessage;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Model;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Protocol;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtobufMessageFactory {
    private ProtobufMessageFactory() {
    }

    public static Protocol.CompositeRequest getChildrenCount(int id, int max) {
        return Protocol.CompositeRequest.newBuilder().setGetChildrenCount(Protocol.GetChildrenCount_Req.newBuilder().setId(id).setCommonRequest(ProtobufMessageFactory.common()).setMaximum(max)).build();
    }

    private static Protocol.CommonRequest.Builder common() {
        return Protocol.CommonRequest.newBuilder();
    }

    public static GeneratedMessage kill() {
        return Protocol.CompositeRequest.newBuilder().setKill(Protocol.Kill_Req.newBuilder().setCommonRequest(ProtobufMessageFactory.common())).build();
    }

    public static Protocol.CompositeRequest detach() {
        return Protocol.CompositeRequest.newBuilder().setDetach(Protocol.Detach_Req.newBuilder().setCommonRequest(ProtobufMessageFactory.common())).build();
    }

    public static Protocol.CompositeRequest attach(int pid) {
        return Protocol.CompositeRequest.newBuilder().setAttach(Protocol.Attach_Req.newBuilder().setPid(pid).setCommonRequest(ProtobufMessageFactory.common())).build();
    }

    public static GeneratedMessage attachByName(String name, boolean wait) {
        return Protocol.CompositeRequest.newBuilder().setAttachByName(Protocol.AttachByName_Req.newBuilder().setName(name).setToWait(wait ? 1 : 0).setCommonRequest(ProtobufMessageFactory.common())).build();
    }

    public static Protocol.CompositeRequest remoteLaunch(String localPath, GeneralCommandLine targetCommandLine, String socket) {
        Protocol.Launch_Req.Builder launchBuilder = ProtobufMessageFactory.createLaunchBuilder(localPath, targetCommandLine, null, null, null);
        launchBuilder.setFdPassingServiceUnixSocket(socket);
        Protocol.CompositeRequest.Builder result2 = Protocol.CompositeRequest.newBuilder();
        result2.setLaunch(launchBuilder);
        return result2.build();
    }

    public static Protocol.CompositeRequest createRemoteTarget(String exePath, String arch, String plugin_name, File deviceLibrariesSymbolsDirectory, String remoteExePath) {
        Protocol.CreateTarget_Req.Builder builder = Protocol.CreateTarget_Req.newBuilder().setArch(arch).setExePath(exePath).setPlatform(plugin_name).setPlatformSdkRoot(deviceLibrariesSymbolsDirectory.getAbsolutePath()).setRemoteExePath(remoteExePath);
        return Protocol.CompositeRequest.newBuilder().setCreateTarget(builder.setCommonRequest(ProtobufMessageFactory.createCommonRequest()).build()).build();
    }

    public static Protocol.CompositeRequest suspend() {
        Protocol.Suspend_Req.Builder builder = Protocol.Suspend_Req.newBuilder().setCommonRequest(ProtobufMessageFactory.common());
        return Protocol.CompositeRequest.newBuilder().setSuspend(builder).build();
    }

    public static Protocol.CompositeRequest removeBreakpoint(int id) {
        Protocol.RemoveBreakpoint_Req.Builder builder = Protocol.RemoveBreakpoint_Req.newBuilder().setId(id).setCommonRequest(ProtobufMessageFactory.common());
        return Protocol.CompositeRequest.newBuilder().setRemoveBreakpoint(builder).build();
    }

    public static Protocol.CompositeRequest removeWatchpoint(int id) {
        Protocol.RemoveWatchpoint_Req.Builder builder = Protocol.RemoveWatchpoint_Req.newBuilder().setId(id).setCommonRequest(ProtobufMessageFactory.common());
        return Protocol.CompositeRequest.newBuilder().setRemoveWatchpoint(builder).build();
    }

    public static Protocol.CompositeRequest addBreakpoint(String path, int line, @Nullable String condition) {
        Protocol.AddBreakpoint_Req.Builder builder = Protocol.AddBreakpoint_Req.newBuilder().setFile(path).setLine(line);
        if (condition != null) {
            builder.setCondition(condition);
        }
        return Protocol.CompositeRequest.newBuilder().setAddBreakpoint(builder.setCommonRequest(ProtobufMessageFactory.common())).build();
    }

    @NotNull
    public static Protocol.CompositeRequest addBreakpoint(@NotNull String pattern, boolean regExpPattern, @Nullable String module, @Nullable String condition, int threadID) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/jetbrains/cidr/execution/debugger/backend/lldb/ProtobufMessageFactory", "addBreakpoint"));
        }
        Protocol.AddBreakpoint_Req.Builder builder = Protocol.AddBreakpoint_Req.newBuilder().setSymbolPattern(pattern);
        builder.setRegexp(regExpPattern);
        builder.setThreadId(threadID);
        if (module != null) {
            builder.setModuleName(module);
        }
        if (condition != null) {
            builder.setCondition(condition);
        }
        Protocol.CompositeRequest compositeRequest = Protocol.CompositeRequest.newBuilder().setAddBreakpoint(builder.setCommonRequest(ProtobufMessageFactory.common())).build();
        if (compositeRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/lldb/ProtobufMessageFactory", "addBreakpoint"));
        }
        return compositeRequest;
    }

    public static Protocol.CompositeRequest getFrames(int threadId, boolean untilValidLineEntry) {
        return Protocol.CompositeRequest.newBuilder().setGetFrames(Protocol.GetFrames_Req.newBuilder().setThreadID(threadId).setUntilValidLineEntry(untilValidLineEntry).setCommonRequest(ProtobufMessageFactory.common())).build();
    }

    public static Protocol.CompositeRequest exit() {
        return Protocol.CompositeRequest.newBuilder().setExit(Protocol.Exit_Req.newBuilder()).build();
    }

    public static Protocol.CompositeRequest launch(GeneralCommandLine targetCommandLine, @Nullable String stdinPath, @Nullable String stdoutPath, @Nullable String stderrPath) {
        Protocol.CompositeRequest.Builder result2 = Protocol.CompositeRequest.newBuilder();
        Protocol.Launch_Req.Builder launchBuilder = ProtobufMessageFactory.createLaunchBuilder(targetCommandLine.getExePath(), targetCommandLine, stdinPath, stdoutPath, stderrPath);
        result2.setLaunch(launchBuilder);
        return result2.build();
    }

    private static Protocol.Launch_Req.Builder createLaunchBuilder(String localPath, GeneralCommandLine targetCommandLine, @Nullable String stdinPath, @Nullable String stdoutPath, @Nullable String stderrPath) {
        Protocol.Launch_Req.Builder launchBuilder = Protocol.Launch_Req.newBuilder();
        Model.CommandLine.Builder cl = Model.CommandLine.newBuilder();
        cl.setExePath(localPath);
        cl.setWorkingDir(targetCommandLine.getWorkDirectory().getAbsolutePath());
        Map envParams = targetCommandLine.getEnvironment();
        if (targetCommandLine.isPassParentEnvironment()) {
            envParams.putAll(targetCommandLine.getParentEnvironment());
        }
        for (String env : envParams.keySet()) {
            cl.addEnv(Model.EnvParam.newBuilder().setName(env).setValue((String)envParams.get(env)));
        }
        for (String param : targetCommandLine.getParametersList().getArray()) {
            cl.addParams(param);
        }
        if (stdinPath != null) {
            cl.setStdinPath(stdinPath);
        }
        if (stdoutPath != null) {
            cl.setStdoutPath(stdoutPath);
        }
        if (stderrPath != null) {
            cl.setStderrPath(stderrPath);
        }
        launchBuilder.setCommandLine(cl);
        launchBuilder.setCommonRequest(ProtobufMessageFactory.common());
        return launchBuilder;
    }

    private static Protocol.CommonRequest createCommonRequest() {
        return ProtobufMessageFactory.common().build();
    }

    public static Protocol.CompositeRequest createTarget(String exePath, String arch) {
        Protocol.CreateTarget_Req.Builder builder = Protocol.CreateTarget_Req.newBuilder().setArch(arch).setExePath(exePath);
        return Protocol.CompositeRequest.newBuilder().setCreateTarget(builder.setCommonRequest(ProtobufMessageFactory.createCommonRequest()).build()).build();
    }

    public static Protocol.CompositeRequest connectPlatform(String platform, String url) {
        Protocol.ConnectPlatform_Req.Builder builder = Protocol.ConnectPlatform_Req.newBuilder().setPlatform(platform).setUrl(url);
        return Protocol.CompositeRequest.newBuilder().setConnectPlatform(builder.setCommonRequest(ProtobufMessageFactory.createCommonRequest()).build()).build();
    }

    public static Protocol.CompositeRequest executeShellCommand(String command, String workingDir, int timeoutSecs) {
        Protocol.ExecuteShellCommand_Req.Builder builder = Protocol.ExecuteShellCommand_Req.newBuilder().setCommand(command).setTimeoutSecs(timeoutSecs);
        if (workingDir != null) {
            builder.setWorkingDir(workingDir);
        }
        return Protocol.CompositeRequest.newBuilder().setExecuteShellCommand(builder.setCommonRequest(ProtobufMessageFactory.createCommonRequest()).build()).build();
    }

    public static Protocol.CompositeRequest resume() {
        return Protocol.CompositeRequest.newBuilder().setContinue(Protocol.Continue_Req.newBuilder().setCommonRequest(ProtobufMessageFactory.common())).build();
    }

    public static Protocol.CompositeRequest stepInto(int threadIndex) {
        return Protocol.CompositeRequest.newBuilder().setStepInto(Protocol.StepInto_Req.newBuilder().setThreadNum(threadIndex).setCommonRequest(ProtobufMessageFactory.common())).build();
    }

    public static Protocol.CompositeRequest stepOut(int threadIndex) {
        return Protocol.CompositeRequest.newBuilder().setStepOut(Protocol.StepOut_Req.newBuilder().setThreadNum(threadIndex).setCommonRequest(ProtobufMessageFactory.common())).build();
    }

    public static Protocol.CompositeRequest stepOver(int threadIndex) {
        return Protocol.CompositeRequest.newBuilder().setStepOver(Protocol.StepOver_Req.newBuilder().setThreadNum(threadIndex).setCommonRequest(ProtobufMessageFactory.common())).build();
    }

    public static Protocol.CompositeRequest evaluateExpression(int frame, int threadId, String expression, @Nullable Model.Language language) {
        Protocol.EvaluateExpression_Req.Builder expressionMsg = Protocol.EvaluateExpression_Req.newBuilder().setCommonRequest(ProtobufMessageFactory.common()).setExpression(expression).setFrameId(frame).setThreadId(threadId);
        if (language != null) {
            expressionMsg.setLanguage(language);
        }
        return Protocol.CompositeRequest.newBuilder().setEvaluateExpression(expressionMsg).build();
    }

    public static Protocol.CompositeRequest handleConsoleCommand(int threadId, int frameNumber, String command) {
        return Protocol.CompositeRequest.newBuilder().setHandleConsoleCommand(Protocol.HandleConsoleCommand_Req.newBuilder().setCommonRequest(ProtobufMessageFactory.common()).setCommand(command).setThreadId(threadId).setFrameIndex(frameNumber)).build();
    }

    public static Protocol.CompositeRequest dispatchInput(String input, Model.DispatchTarget target) {
        return Protocol.CompositeRequest.newBuilder().setDispatchInput(Protocol.DispatchInput_Req.newBuilder().setCommonRequest(ProtobufMessageFactory.common()).setInput(input).setTarget(target)).build();
    }

    public static Protocol.CompositeRequest handleCompletion(String command, int pos) {
        return Protocol.CompositeRequest.newBuilder().setHandleCompletion(Protocol.HandleCompletion_Req.newBuilder().setCommonRequest(ProtobufMessageFactory.common()).setCommand(command).setPos(pos)).build();
    }

    public static Protocol.CompositeRequest handleSignal(String signalName, boolean stop2, boolean pass, boolean notify) {
        return Protocol.CompositeRequest.newBuilder().setHandleSignal(Protocol.HandleSignal_Req.newBuilder().setCommonRequest(ProtobufMessageFactory.common()).setSignal(signalName).setStop(stop2).setPass(pass).setNotify(notify)).build();
    }

    public static Protocol.CompositeRequest getValueChildren(int id, int offset, int count) {
        return Protocol.CompositeRequest.newBuilder().setGetValueChildren(Protocol.GetValueChildren_Req.newBuilder().setCommonRequest(ProtobufMessageFactory.common()).setId(id).setOffset(offset).setCount(count)).build();
    }

    public static Protocol.CompositeRequest getObjectDescription(int id, int length) {
        return Protocol.CompositeRequest.newBuilder().setGetObjectDescription(Protocol.GetObjectDescription_Req.newBuilder().setId(id).setLength(length).setCommonRequest(ProtobufMessageFactory.common())).build();
    }

    public static Protocol.CompositeRequest arraySlice(int id, int offset, int count) {
        return Protocol.CompositeRequest.newBuilder().setGetArraySlice(Protocol.GetArraySlice_Req.newBuilder().setCommonRequest(ProtobufMessageFactory.common()).setValueId(id).setOffset(offset).setCount(count)).build();
    }

    public static Protocol.CompositeRequest addWatchpoint(int id, @Nullable String condition, boolean read, boolean write, boolean resolveLocation) {
        Protocol.AddWatchpoint_Req.Builder builder = Protocol.AddWatchpoint_Req.newBuilder().setCommonRequest(ProtobufMessageFactory.common()).setRead(read ? 1 : 0).setWrite(write ? 1 : 0).setToResolveLocation(resolveLocation ? 1 : 0).setValueId(id);
        if (condition != null) {
            builder.setCondition(condition);
        }
        return Protocol.CompositeRequest.newBuilder().setAddWatchpoint(builder).build();
    }

    public static Protocol.CompositeRequest getLocals(int threadID, int frameIndex) {
        return Protocol.CompositeRequest.newBuilder().setGetLocals(Protocol.GetLocals_Req.newBuilder().setCommonRequest(ProtobufMessageFactory.common()).setFrameIndex(frameIndex).setThreadID(threadID)).build();
    }

    public static Protocol.CompositeRequest setDynamicValuesPolicy(Model.DynamicValuesPolicy policy) {
        return Protocol.CompositeRequest.newBuilder().setDynamicValuesPolicy(Protocol.DynamicValuesPolicy_Req.newBuilder().setCommonRequest(ProtobufMessageFactory.common()).setUseDynamic(policy)).build();
    }

    public static Protocol.CompositeRequest setValuesFilteringEnabled(boolean enabled) {
        return Protocol.CompositeRequest.newBuilder().setValuesFilteringPolicy(Protocol.ValuesFilteringPolicy_Req.newBuilder().setCommonRequest(ProtobufMessageFactory.common()).setFilterEnabled(enabled ? 1 : 0)).build();
    }
}

