/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectVariablesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LLDBEvaluationContext
extends EvaluationContext {
    private final DebuggerDriver myDriver;

    public LLDBEvaluationContext(DebuggerDriver driver, Expirable expirable, CidrStackFrame frame) {
        super(driver, expirable, frame);
        this.myDriver = driver;
    }

    @Override
    public List<LLValue> arraySlice(LLValue var, int offset, int count) throws ExecutionException, DBCannotEvaluateException, DBCannotCollectVariablesException {
        this.checkExpiration();
        return ((LLDBDriver)this.myDriver).arraySlice(var, offset, count);
    }

    @Override
    public String mangleType(String type) {
        return type;
    }

    @Override
    @NotNull
    public String castIDToNumber(@NotNull String expr, @NotNull String type) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBEvaluationContext", "castIDToNumber"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBEvaluationContext", "castIDToNumber"));
        }
        String string = LLDBEvaluationContext.cast(expr, "long");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBEvaluationContext", "castIDToNumber"));
        }
        return string;
    }

    @Override
    @NotNull
    public String convertToRValue(@NotNull LLValue lValue, @NotNull Pair<LLValue, String> rValuePair) throws DBCannotEvaluateException {
        if (lValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lValue", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBEvaluationContext", "convertToRValue"));
        }
        if (rValuePair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rValuePair", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBEvaluationContext", "convertToRValue"));
        }
        if (((LLValue)((Object)rValuePair.getFirst())).isNilPointer()) {
            if ("((id)nil)" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBEvaluationContext", "convertToRValue"));
            }
            return "((id)nil)";
        }
        String string = lValue.isPointer() && ((LLValue)((Object)rValuePair.first)).getType().equals("int") && ((LLValue)((Object)rValuePair.first)).intValue() == 0L ? "0" : (String)rValuePair.getSecond();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBEvaluationContext", "convertToRValue"));
        }
        return string;
    }

    @Override
    @NotNull
    public String objectDescription(LLValue value) throws ExecutionException, DBCannotEvaluateException {
        String description = ((LLDBDriver)this.myDriver).getObjectDescription(value, 524288);
        if ("<object returned empty description>".equals(description)) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBEvaluationContext", "objectDescription"));
            }
            return "";
        }
        String string = description;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/lldb/LLDBEvaluationContext", "objectDescription"));
        }
        return string;
    }
}

