/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.HashMap;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBResponse;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbBaseVisitor;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbParser;
import org.antlr.v4.runtime.misc.NotNull;

public class GDBResponseVisitor
extends GdbBaseVisitor<GDBResponse> {
    private static final HashMap<String, GDBResponse.ResultRecord.Type> resultTypeMap = new HashMap();

    public GDBResponse getResponse(String varName, GDBResponse.ResultRecord val) {
        GDBTuple r = new GDBTuple();
        if (val.getType() == GDBResponse.ResultRecord.Type.str_value) {
            r.add(Couple.of((Object)varName, (Object)((Pair)val.getResultList().get((int)0)).first));
        } else if (val.getType() == GDBResponse.ResultRecord.Type.tuple_value) {
            r.add(Pair.create((Object)varName, (Object)val.getResultList()));
        } else if (val.getType() == GDBResponse.ResultRecord.Type.list_value) {
            assert (val.getResultList().size() == 1);
            r.add(Pair.create((Object)varName, (Object)((GDBTuple)val.getResultList().get(0))));
        } else assert (false);
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.kind, GDBResponse.ResultRecord.Type.result, r);
    }

    @Override
    public GDBResponse visitResult(@NotNull GdbParser.ResultContext ctx) {
        GDBResponse.ResultRecord val = (GDBResponse.ResultRecord)this.visitValue(ctx.value());
        return this.getResponse(ctx.variable().getText(), val);
    }

    @Override
    public GDBResponse visitMultiple_bkpt_result(@NotNull GdbParser.Multiple_bkpt_resultContext ctx) {
        assert (ctx.value().size() > 0);
        GDBResponse.ResultRecord val = (GDBResponse.ResultRecord)this.visitValue(ctx.value(0));
        return this.getResponse("bkpt", val);
    }

    @Override
    public GDBResponse visitCnst(@NotNull GdbParser.CnstContext ctx) {
        GDBTuple r = new GDBTuple();
        String str = ctx.c_string().getText();
        assert (str.length() >= 2);
        r.add(Couple.of((Object)DebuggerDriver.unescapeString(str.substring(1, str.length() - 1)), null));
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.kind, GDBResponse.ResultRecord.Type.str_value, r);
    }

    @Override
    public GDBResponse visitTuple(@NotNull GdbParser.TupleContext ctx) {
        GDBTuple results = new GDBTuple();
        int i = 0;
        while (ctx.result(i) != null) {
            GdbParser.ResultContext rctx = ctx.result(i);
            GDBResponse.ResultRecord res = (GDBResponse.ResultRecord)this.visitResult(rctx);
            assert (res.getResultList().size() == 1);
            results.add(res.getResultList().get(0));
            ++i;
        }
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.kind, GDBResponse.ResultRecord.Type.tuple_value, results);
    }

    @Override
    public GDBResponse visitList(@NotNull GdbParser.ListContext ctx) {
        GDBTuple result2 = new GDBTuple();
        GDBTuple list = new GDBTuple();
        if (ctx.result(0) != null) {
            int i = 0;
            while (ctx.result(i) != null) {
                GdbParser.ResultContext rctx = ctx.result(i);
                GDBResponse.ResultRecord res = (GDBResponse.ResultRecord)this.visitResult(rctx);
                assert (res.getResultList().size() == 1);
                list.add(res.getResultList().get(0));
                ++i;
            }
        } else {
            int i = 0;
            while (ctx.value(i) != null) {
                GdbParser.ValueContext rctx = ctx.value(i);
                GDBResponse.ResultRecord res = (GDBResponse.ResultRecord)this.visitValue(rctx);
                if (res.getType() == GDBResponse.ResultRecord.Type.str_value) {
                    list.add(((Couple)res.getResultList().get((int)0)).first);
                } else if (res.getType() == GDBResponse.ResultRecord.Type.tuple_value) {
                    list.add(res.getResultList());
                } else if (res.getType() == GDBResponse.ResultRecord.Type.list_value) {
                    assert (res.getResultList().size() == 1);
                    list.add((GDBTuple)res.getResultList().get(0));
                } else assert (false);
                ++i;
            }
        }
        result2.add(list);
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.kind, GDBResponse.ResultRecord.Type.list_value, result2);
    }

    @Override
    public GDBResponse visitBreakResult(@NotNull GdbParser.BreakResultContext ctx) {
        String typeStr = "done";
        GDBResponse.ResultRecord.Type type = (GDBResponse.ResultRecord.Type)resultTypeMap.get((Object)typeStr);
        GDBTuple results = new GDBTuple();
        GDBResponse.ResultRecord res = (GDBResponse.ResultRecord)this.visitMultiple_bkpt_result(ctx.multiple_bkpt_result());
        assert (res.getResultList().size() == 1);
        results.add(res.getResultList().get(0));
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.kind, type, results);
    }

    @Override
    public GDBResponse visitCommonResult(@NotNull GdbParser.CommonResultContext ctx) {
        String typeStr = ctx.result_class().getText();
        GDBResponse.ResultRecord.Type type = (GDBResponse.ResultRecord.Type)resultTypeMap.get((Object)typeStr);
        GDBTuple results = new GDBTuple();
        int i = 0;
        while (ctx.result(i) != null) {
            GdbParser.ResultContext rctx = ctx.result(i);
            GDBResponse.ResultRecord res = (GDBResponse.ResultRecord)this.visitResult(rctx);
            assert (res.getResultList().size() == 1);
            results.add(res.getResultList().get(0));
            ++i;
        }
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.kind, type, results);
    }

    @Override
    public GDBResponse visitExec_async_output(@NotNull GdbParser.Exec_async_outputContext ctx) {
        String typeStr = ctx.async_output().async_class().getText();
        GDBTuple results = new GDBTuple();
        int i = 0;
        while (ctx.async_output().result(i) != null) {
            GdbParser.ResultContext rctx = ctx.async_output().result(i);
            GDBResponse.ResultRecord res = (GDBResponse.ResultRecord)this.visitResult(rctx);
            assert (res.getResultList().size() == 1);
            results.add(res.getResultList().get(0));
            ++i;
        }
        return new GDBResponse.AsyncRecord(GDBResponse.AsyncRecord.Category.exec, typeStr, results);
    }

    @Override
    public GDBResponse visitStatus_async_output(@NotNull GdbParser.Status_async_outputContext ctx) {
        String typeStr = ctx.async_output().async_class().getText();
        GDBTuple results = new GDBTuple();
        int i = 0;
        while (ctx.async_output().result(i) != null) {
            GdbParser.ResultContext rctx = ctx.async_output().result(i);
            GDBResponse.ResultRecord res = (GDBResponse.ResultRecord)this.visitResult(rctx);
            assert (res.getResultList().size() == 1);
            results.add(res.getResultList().get(0));
            ++i;
        }
        return new GDBResponse.AsyncRecord(GDBResponse.AsyncRecord.Category.status, typeStr, results);
    }

    @Override
    public GDBResponse visitCommonNotification(@NotNull GdbParser.CommonNotificationContext ctx) {
        String typeStr = ctx.async_output().async_class().getText();
        GDBTuple results = new GDBTuple();
        int i = 0;
        while (ctx.async_output().result(i) != null) {
            GdbParser.ResultContext rctx = ctx.async_output().result(i);
            GDBResponse.ResultRecord res = (GDBResponse.ResultRecord)this.visitResult(rctx);
            assert (res.getResultList().size() == 1);
            results.add(res.getResultList().get(0));
            ++i;
        }
        return new GDBResponse.AsyncRecord(GDBResponse.AsyncRecord.Category.notify, typeStr, results);
    }

    @Override
    public GDBResponse visitCorruptedMemoryChangedNotification(@NotNull GdbParser.CorruptedMemoryChangedNotificationContext ctx) {
        String typeStr = "memory-changed";
        GDBTuple results = new GDBTuple();
        String str = ctx.cnst().c_string().getText();
        results.add(Couple.of((Object)"thread-group", (Object)str.substring(1, str.length() - 1)));
        int i = 0;
        while (ctx.result(i) != null) {
            GdbParser.ResultContext rctx = ctx.result(i);
            GDBResponse.ResultRecord res = (GDBResponse.ResultRecord)this.visitResult(rctx);
            assert (res.getResultList().size() == 1);
            results.add(res.getResultList().get(0));
            ++i;
        }
        return new GDBResponse.AsyncRecord(GDBResponse.AsyncRecord.Category.notify, typeStr, results);
    }

    @Override
    public GDBResponse visitBreakModified(@NotNull GdbParser.BreakModifiedContext ctx) {
        String typeStr = "breakpoint-modified";
        GDBTuple results = new GDBTuple();
        GDBResponse.ResultRecord res = (GDBResponse.ResultRecord)this.visitMultiple_bkpt_result(ctx.multiple_bkpt_result());
        results.add(res.getResultList().get(0));
        return new GDBResponse.AsyncRecord(GDBResponse.AsyncRecord.Category.notify, typeStr, results);
    }

    @Override
    public GDBResponse visitBreakCreated(@NotNull GdbParser.BreakCreatedContext ctx) {
        String typeStr = "breakpoint-created";
        GDBTuple results = new GDBTuple();
        GDBResponse.ResultRecord res = (GDBResponse.ResultRecord)this.visitMultiple_bkpt_result(ctx.multiple_bkpt_result());
        results.add(res.getResultList().get(0));
        return new GDBResponse.AsyncRecord(GDBResponse.AsyncRecord.Category.notify, typeStr, results);
    }

    @Override
    public GDBResponse visitConsole_stream_output(@NotNull GdbParser.Console_stream_outputContext ctx) {
        String output = DebuggerDriver.unescapeString(ctx.c_string().getText());
        assert (output.length() >= 2);
        return new GDBResponse.StreamRecord(GDBResponse.StreamRecord.Category.console, output.substring(1, output.length() - 1));
    }

    @Override
    public GDBResponse visitLog_stream_output(@NotNull GdbParser.Log_stream_outputContext ctx) {
        String output = DebuggerDriver.unescapeString(ctx.c_string().getText());
        assert (output.length() >= 2);
        return new GDBResponse.StreamRecord(GDBResponse.StreamRecord.Category.log, output.substring(1, output.length() - 1));
    }

    static {
        resultTypeMap.put((Object)"done", (Object)GDBResponse.ResultRecord.Type.done);
        resultTypeMap.put((Object)"running", (Object)GDBResponse.ResultRecord.Type.running);
        resultTypeMap.put((Object)"connected", (Object)GDBResponse.ResultRecord.Type.connected);
        resultTypeMap.put((Object)"error", (Object)GDBResponse.ResultRecord.Type.error);
        resultTypeMap.put((Object)"exit", (Object)GDBResponse.ResultRecord.Type.exit);
        resultTypeMap.put((Object)"stepping", (Object)GDBResponse.ResultRecord.Type.stepping);
        resultTypeMap.put((Object)"continuing", (Object)GDBResponse.ResultRecord.Type.continuing);
    }
}

