/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLBreakpoint
extends LLCodepoint {
    @NotNull
    private final String myFile;
    private final int myLine;
    private final boolean myPending;
    @Nullable
    private String myCondition;
    @Nullable
    private String myConditionError;

    public LLBreakpoint(int id, @NotNull String file2, int line, boolean pending, @Nullable String condition, @Nullable String conditionError) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/execution/debugger/backend/LLBreakpoint", "<init>"));
        }
        super(id);
        this.myFile = file2;
        this.myLine = line;
        this.myPending = pending;
        this.myCondition = condition;
        this.myConditionError = conditionError;
    }

    @NotNull
    public String getFile() {
        String string = this.myFile;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/LLBreakpoint", "getFile"));
        }
        return string;
    }

    public int getLine() {
        return this.myLine;
    }

    @Nullable
    public String getCondition() {
        return this.myCondition;
    }

    @Nullable
    public String getConditionError() {
        return this.myConditionError;
    }

    public String toString() {
        String result2 = "Breakpoint-" + this.getId() + "@" + this.myFile + ":" + this.myLine;
        if (this.myPending) {
            result2 = result2 + "(pending)";
        }
        if (this.myCondition != null) {
            result2 = result2 + ":condition:" + this.myCondition;
        }
        if (this.myConditionError != null) {
            result2 = result2 + ":condition-error:" + this.myConditionError;
        }
        return result2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LLBreakpoint that = (LLBreakpoint)o;
        if (this.myLine != that.myLine) {
            return false;
        }
        if (this.myPending != that.myPending) {
            return false;
        }
        if (this.myCondition != null ? !this.myCondition.equals(that.myCondition) : that.myCondition != null) {
            return false;
        }
        if (this.myConditionError != null ? !this.myConditionError.equals(that.myConditionError) : that.myConditionError != null) {
            return false;
        }
        return this.myFile.equals(that.myFile);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myFile.hashCode();
        result2 = 31 * result2 + this.myLine;
        result2 = 31 * result2 + (this.myPending ? 1 : 0);
        result2 = 31 * result2 + (this.myCondition != null ? this.myCondition.hashCode() : 0);
        result2 = 31 * result2 + (this.myConditionError != null ? this.myConditionError.hashCode() : 0);
        return result2;
    }
}

