/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDebuggerPathManager {
    @NotNull
    public static File getLLDBBinFile(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/jetbrains/cidr/execution/debugger/CidrDebuggerPathManager", "getLLDBBinFile"));
        }
        File file2 = new File(PathManager.getBinPath(), relativePath);
        if (!file2.exists()) {
            String selector = SystemInfo.isWindows ? "win/" : (SystemInfo.isMac ? "mac/" : "linux/");
            file2 = new File(new File(PathManager.getHomePath(), "CIDR/cidr-debugger/bin/LLDB/" + selector), relativePath);
        }
        File file3 = file2;
        if (file3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/CidrDebuggerPathManager", "getLLDBBinFile"));
        }
        return file3;
    }

    @NotNull
    public static File getBundledLLDBSTLPrettyPrinters() {
        File file2 = new File(PathManager.getBinPath(), "stl_printers");
        if (!file2.exists()) {
            file2 = new File(PathManager.getHomePath(), "CIDR/cidr-debugger/bin/LLDB/shared/stl_printers");
        }
        File file3 = file2;
        if (file3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/CidrDebuggerPathManager", "getBundledLLDBSTLPrettyPrinters"));
        }
        return file3;
    }

    @Nullable
    public static File getSystemPythonBinDir() {
        File pythonBinDir = new File("/System/Library/Frameworks/Python.framework/Versions/Current/bin");
        if (pythonBinDir.exists() && pythonBinDir.isDirectory()) {
            return pythonBinDir;
        }
        return null;
    }

    @NotNull
    public static File getBundledGDBBinary() {
        String gdbExeSubPath = SystemInfo.isWindows ? "gdb.exe" : "gdb";
        File file2 = new File(PathManager.getBinPath(), "gdb/bin/" + gdbExeSubPath);
        if (!file2.exists()) {
            String selector = SystemInfo.isWindows ? "bin_win/" : (SystemInfo.isMac ? "bin_mac/" : "bin_linux/");
            File file3 = new File(PathManager.getHomePath(), "CIDR/clion/bin/gdb/" + selector + gdbExeSubPath);
            if (file3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/CidrDebuggerPathManager", "getBundledGDBBinary"));
            }
            return file3;
        }
        File file4 = file2;
        if (file4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/CidrDebuggerPathManager", "getBundledGDBBinary"));
        }
        return file4;
    }

    @NotNull
    public static File getGDBBinFile(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/jetbrains/cidr/execution/debugger/CidrDebuggerPathManager", "getGDBBinFile"));
        }
        File file2 = new File(PathManager.getBinPath(), "gdb/bin/" + relativePath);
        if (!file2.exists()) {
            String selector = SystemInfo.isWindows ? "win/" : (SystemInfo.isMac ? "mac/" : "linux/");
            file2 = new File(new File(PathManager.getHomePath(), "CIDR/cidr-debugger/bin/GDB/" + selector), relativePath);
        }
        File file3 = file2;
        if (file3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/CidrDebuggerPathManager", "getGDBBinFile"));
        }
        return file3;
    }

    @NotNull
    public static File getBundledPythonHome() {
        File file2 = new File(PathManager.getBinPath(), "gdb/lib/python2.7");
        file2 = file2.exists() ? file2.getParentFile().getParentFile() : new File(PathManager.getHomePath(), "CIDR/clion/bin/gdb");
        File file3 = file2;
        if (file3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/CidrDebuggerPathManager", "getBundledPythonHome"));
        }
        return file3;
    }

    @NotNull
    public static File getBundledGNUSTLPrettyPrinters() {
        File file2 = new File(PathManager.getBinPath(), "gdb/share/gdb/stl_printers");
        if (!file2.exists()) {
            file2 = new File(PathManager.getHomePath(), "CIDR/clion/bin/gdb/share/gdb/stl_printers");
        }
        File file3 = file2;
        if (file3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/CidrDebuggerPathManager", "getBundledGNUSTLPrettyPrinters"));
        }
        return file3;
    }
}

