/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.jetbrains.cidr.execution.BuildTargetData;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutableData {
    @Nullable
    public final BuildTargetData target;
    @Nullable
    public final String path;

    public ExecutableData(@NotNull BuildTargetData target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/cidr/execution/ExecutableData", "<init>"));
        }
        this.target = target;
        this.path = null;
    }

    public ExecutableData(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/cidr/execution/ExecutableData", "<init>"));
        }
        this.target = null;
        this.path = path;
    }

    public String toString() {
        return this.path != null ? "Path: " + this.path : "Target: " + this.target;
    }

    @Nullable
    public static ExecutableData loadExternal(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/execution/ExecutableData", "loadExternal"));
        }
        String runProjectName = element.getAttributeValue("RUN_TARGET_PROJECT_NAME");
        String runTargetName = element.getAttributeValue("RUN_TARGET_NAME");
        String runPath = element.getAttributeValue("RUN_PATH");
        if (runPath != null) {
            return new ExecutableData(runPath);
        }
        if (runProjectName != null && runTargetName != null) {
            return new ExecutableData(new BuildTargetData(runProjectName, runTargetName));
        }
        return null;
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/execution/ExecutableData", "writeExternal"));
        }
        if (this.target != null) {
            element.setAttribute("RUN_TARGET_PROJECT_NAME", this.target.projectName);
            element.setAttribute("RUN_TARGET_NAME", this.target.targetName);
        } else if (this.path != null) {
            element.setAttribute("RUN_PATH", this.path);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutableData data = (ExecutableData)o;
        if (this.path != null ? !this.path.equals(data.path) : data.path != null) {
            return false;
        }
        return !(this.target != null ? !this.target.equals(data.target) : data.target != null);
    }

    public int hashCode() {
        int result2 = this.target != null ? this.target.hashCode() : 0;
        result2 = 31 * result2 + (this.path != null ? this.path.hashCode() : 0);
        return result2;
    }
}

