/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.ExecutionResult;
import java.io.File;
import java.util.Map;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrExecUtil {
    private static final int ERROR_MESSAGE_WRAP_LENGTH = 80;

    @NotNull
    public static Map<String, String> appendBuildPathVars(@NotNull Map<String, String> env, @Nullable String buildPath) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/cidr/execution/CidrExecUtil", "appendBuildPathVars"));
        }
        CidrExecUtil.appendSearchPath(env, "DYLD_LIBRARY_PATH", buildPath);
        CidrExecUtil.appendSearchPath(env, "DYLD_FRAMEWORK_PATH", buildPath);
        CidrExecUtil.appendSearchPath(env, "__XPC_DYLD_LIBRARY_PATH", buildPath);
        CidrExecUtil.appendSearchPath(env, "__XPC_DYLD_FRAMEWORK_PATH", buildPath);
        Map<String, String> map = env;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/CidrExecUtil", "appendBuildPathVars"));
        }
        return map;
    }

    public static void setIfAbsent(@NotNull Map<String, String> env, @NotNull String paramName, @Nullable String value) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/cidr/execution/CidrExecUtil", "setIfAbsent"));
        }
        if (paramName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramName", "com/jetbrains/cidr/execution/CidrExecUtil", "setIfAbsent"));
        }
        if (value != null && !env.containsKey(paramName)) {
            env.put(paramName, value);
        }
    }

    public static void appendSearchPath(@NotNull Map<String, String> env, @NotNull String paramName, @Nullable String appendPath) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/cidr/execution/CidrExecUtil", "appendSearchPath"));
        }
        if (paramName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramName", "com/jetbrains/cidr/execution/CidrExecUtil", "appendSearchPath"));
        }
        if (appendPath == null) {
            return;
        }
        String result2 = env.get(paramName);
        result2 = result2 != null ? result2 + File.pathSeparator + appendPath : appendPath;
        env.put(paramName, result2);
    }

    public static void checkErrorOnTermination(@NotNull StringBuilder errOut, @NotNull ExecutionResult<?> result2) {
        if (errOut == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errOut", "com/jetbrains/cidr/execution/CidrExecUtil", "checkErrorOnTermination"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/execution/CidrExecUtil", "checkErrorOnTermination"));
        }
        if (result2.isDone()) {
            return;
        }
        String error = errOut.toString();
        ExecutionException ex = null;
        if (!StringUtil.isEmptyOrSpaces((String)error)) {
            ex = new ExecutionException(error);
        }
        result2.setException((Throwable)new ExecutionFinishedException((Throwable)ex));
    }

    public static String wrapErrorOutput(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/jetbrains/cidr/execution/CidrExecUtil", "wrapErrorOutput"));
        }
        return CidrExecUtil.wrapErrorOutput(str, 80);
    }

    public static String wrapErrorOutput(@NotNull String str, int wrapLen) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/jetbrains/cidr/execution/CidrExecUtil", "wrapErrorOutput"));
        }
        String[] lines = StringUtil.splitByLinesKeepSeparators((String)str);
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            StringTokenizer st = new StringTokenizer(lines[i], " \n\r");
            if (st.hasMoreTokens()) {
                String word = st.nextToken();
                result2.append(word);
                int lineLen = word.length();
                while (st.hasMoreTokens()) {
                    word = st.nextToken();
                    int wordLen = word.length();
                    if (lineLen + wordLen > wrapLen) {
                        result2.append('\n');
                        lineLen = wordLen;
                    } else {
                        result2.append(' ');
                        lineLen += wordLen + 1;
                    }
                    result2.append(word);
                }
            }
            if (i >= lines.length - 1) continue;
            result2.append('\n');
        }
        return result2.toString();
    }
}

