/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.jetbrains.cidr.execution.CidrExecUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrCommandLineConfigurator {
    @NotNull
    private final Project myProject;
    @NotNull
    private final SimpleProgramParameters myAppParameters;

    public CidrCommandLineConfigurator(@NotNull Project project, @NotNull SimpleProgramParameters appParameters) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/execution/CidrCommandLineConfigurator", "<init>"));
        }
        if (appParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appParameters", "com/jetbrains/cidr/execution/CidrCommandLineConfigurator", "<init>"));
        }
        this.myProject = project;
        this.myAppParameters = appParameters;
    }

    @Nullable
    public File getAppWorkingDir() {
        String result2 = this.myAppParameters.getWorkingDirectory();
        return StringUtil.isEmptyOrSpaces((String)result2) ? null : new File(result2);
    }

    public void configureCommandLine(@NotNull GeneralCommandLine cl) throws ExecutionException {
        if (cl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cl", "com/jetbrains/cidr/execution/CidrCommandLineConfigurator", "configureCommandLine"));
        }
        Charset charset = EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset();
        cl.setCharset(charset);
        cl.setWorkDirectory(this.getAppWorkingDir());
        cl.getParametersList().addAll(this.myAppParameters.getProgramParametersList().getList());
        Map env = cl.getEnvironment();
        env.putAll(this.myAppParameters.getEnv());
        if (SystemInfo.isMac) {
            CidrExecUtil.setIfAbsent(env, "NSUnbufferedIO", "YES");
        }
        cl.setPassParentEnvironment(this.myAppParameters.isPassParentEnvs());
    }
}

