/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrBuildTargetWithConfigurations;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrBuildConfigurationHelper<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTargetWithConfigurations<BC>> {
    @NotNull
    public abstract List<TARGET> getTargets();

    @NotNull
    public List<BC> getConfigurations(@Nullable TARGET target) {
        List<Object> list = target == null ? Collections.emptyList() : target.getBuildConfigurations();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/CidrBuildConfigurationHelper", "getConfigurations"));
        }
        return list;
    }

    @Nullable
    public abstract CidrBuildConfiguration getDefaultConfiguration(@Nullable TARGET var1);

    @NotNull
    public abstract List<? extends TARGET> getRunTargets();

    @Nullable
    public abstract TARGET findRunTarget(@Nullable BuildTargetData var1);

    @Nullable
    public abstract TARGET findTarget(@Nullable BuildTargetData var1);

    @Nullable
    public abstract BC findConfiguration(@Nullable TARGET var1, @Nullable String var2);

    @Nullable
    public TARGET getDefaultTarget() {
        return (TARGET)((CidrBuildTargetWithConfigurations)ContainerUtil.getFirstItem(this.getTargets()));
    }

    @Nullable
    public TARGET findFirstSuitableTarget(@Nullable String targetName) {
        return (TARGET)((CidrBuildTargetWithConfigurations)CidrBuildConfigurationHelper.findFirstSuitableTarget(this.getTargets(), targetName));
    }

    @Contract(value="_, null -> null")
    public static <T extends CidrBuildTarget> T findFirstSuitableTarget(@NotNull List<T> targets, @Nullable String targetName) {
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/jetbrains/cidr/execution/CidrBuildConfigurationHelper", "findFirstSuitableTarget"));
        }
        if (targetName == null) {
            return null;
        }
        for (CidrBuildTarget each : targets) {
            if (!each.getName().equals(targetName)) continue;
            return (T)each;
        }
        return null;
    }

    @Nullable
    public BuildTargetAndConfigurationData findSimilarValidInTargets(@Nullable BuildTargetAndConfigurationData btc, @NotNull List<TARGET> targetsWithContext) {
        if (targetsWithContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetsWithContext", "com/jetbrains/cidr/execution/CidrBuildConfigurationHelper", "findSimilarValidInTargets"));
        }
        if (btc == null || btc.target == null || btc.configurationName == null) {
            return null;
        }
        TARGET selectedTarget = this.findTarget(btc.target);
        if (selectedTarget == null) {
            return null;
        }
        return this.findSimilarValidInTargets(this.findConfiguration(selectedTarget, btc.configurationName), selectedTarget, targetsWithContext);
    }

    @Nullable
    public abstract BuildTargetAndConfigurationData findSimilarValidInTargets(@Nullable BC var1, @Nullable TARGET var2, @NotNull List<TARGET> var3);

    @Contract(value="null, _, _ -> null")
    protected static <BC extends CidrBuildConfiguration, TARGET extends CidrBuildTargetWithConfigurations<BC>> BuildTargetAndConfigurationData createIfSuitable(@Nullable BC selectedConfiguration, @Nullable TARGET selectedTarget, @NotNull List<TARGET> targetsWithContext) {
        if (targetsWithContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetsWithContext", "com/jetbrains/cidr/execution/CidrBuildConfigurationHelper", "createIfSuitable"));
        }
        return selectedConfiguration != null && targetsWithContext.contains(selectedTarget) ? new BuildTargetAndConfigurationData(selectedTarget, selectedConfiguration) : null;
    }
}

