/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import org.jetbrains.annotations.NotNull;

public final class BuildTargetData {
    @NotNull
    public final String projectName;
    @NotNull
    public final String targetName;

    public BuildTargetData(@NotNull String projectName, @NotNull String targetName) {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/jetbrains/cidr/execution/BuildTargetData", "<init>"));
        }
        if (targetName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetName", "com/jetbrains/cidr/execution/BuildTargetData", "<init>"));
        }
        this.projectName = projectName;
        this.targetName = targetName;
    }

    public BuildTargetData(@NotNull CidrBuildTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/jetbrains/cidr/execution/BuildTargetData", "<init>"));
        }
        this(target.getProjectName(), target.getName());
    }

    public String toString() {
        return this.getDisplayString();
    }

    @NotNull
    public String getDisplayString() {
        String string = BuildTargetAndConfigurationData.formatDisplayString(this.projectName, this.targetName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/BuildTargetData", "getDisplayString"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildTargetData that = (BuildTargetData)o;
        if (!this.projectName.equals(that.projectName)) {
            return false;
        }
        return this.targetName.equals(that.targetName);
    }

    public int hashCode() {
        int result2 = this.projectName.hashCode();
        result2 = 31 * result2 + this.targetName.hashCode();
        return result2;
    }
}

