/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttlistDecl;
import com.intellij.psi.xml.XmlConditionalSection;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlMarkupDecl;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class AddDtdDeclarationFix
implements LocalQuickFix {
    private final String myMessageKey;
    private final String myElementDeclarationName;
    private final String myReference;

    public AddDtdDeclarationFix(@PropertyKey(resourceBundle="messages.XmlBundle") String messageKey, @NotNull String elementDeclarationName, @NotNull PsiReference reference) {
        if (elementDeclarationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementDeclarationName", "com/intellij/xml/util/AddDtdDeclarationFix", "<init>"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/xml/util/AddDtdDeclarationFix", "<init>"));
        }
        this.myMessageKey = messageKey;
        this.myElementDeclarationName = elementDeclarationName;
        this.myReference = reference.getCanonicalText();
    }

    @NotNull
    public String getName() {
        String string = XmlBundle.message((String)this.myMessageKey, (Object[])new Object[]{this.myReference});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/AddDtdDeclarationFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/AddDtdDeclarationFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/util/AddDtdDeclarationFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/xml/util/AddDtdDeclarationFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        PsiFile containingFile = element.getContainingFile();
        if (!FileModificationService.getInstance().prepareFileForWrite(containingFile)) {
            return;
        }
        String prefixToInsert = "";
        String suffixToInsert = "";
        int UNDEFINED_OFFSET = -1;
        int anchorOffset = -1;
        PsiElement anchor = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{XmlElementDecl.class, XmlAttlistDecl.class, XmlEntityDecl.class, XmlConditionalSection.class});
        if (anchor != null) {
            anchorOffset = anchor.getTextRange().getStartOffset();
        }
        if (anchorOffset == -1 && containingFile.getLanguage() == XMLLanguage.INSTANCE) {
            XmlFile file2 = (XmlFile)containingFile;
            XmlProlog prolog = file2.getDocument().getProlog();
            assert (prolog != null);
            XmlDoctype doctype = prolog.getDoctype();
            XmlMarkupDecl markupDecl = doctype != null ? doctype.getMarkupDecl() : null;
            if (doctype == null) {
                XmlTag rootTag = file2.getDocument().getRootTag();
                prefixToInsert = "<!DOCTYPE " + (rootTag != null ? rootTag.getName() : "null");
                suffixToInsert = ">\n";
            }
            if (markupDecl == null) {
                prefixToInsert = prefixToInsert + " [\n";
                suffixToInsert = "]" + suffixToInsert;
                anchorOffset = doctype != null ? doctype.getTextRange().getEndOffset() - 1 : prolog.getTextRange().getEndOffset();
            }
        }
        if (anchorOffset == -1) {
            anchorOffset = element.getTextRange().getStartOffset();
        }
        OpenFileDescriptor openDescriptor = new OpenFileDescriptor(project, containingFile.getVirtualFile(), anchorOffset);
        Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(openDescriptor, true);
        TemplateManager templateManager = TemplateManager.getInstance(project);
        Template t = templateManager.createTemplate("", "");
        if (!prefixToInsert.isEmpty()) {
            t.addTextSegment(prefixToInsert);
        }
        t.addTextSegment("<!" + this.myElementDeclarationName + " " + this.myReference + " ");
        t.addEndVariable();
        t.addTextSegment(">\n");
        if (!suffixToInsert.isEmpty()) {
            t.addTextSegment(suffixToInsert);
        }
        templateManager.startTemplate(editor, t);
    }
}

