/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.openapi.vfs.ex.http.HttpVirtualFileListener;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.BreakpointState;
import com.intellij.xdebugger.impl.breakpoints.CustomizedBreakpointPresentation;
import com.intellij.xdebugger.impl.breakpoints.LineBreakpointState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointsDialogState;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointManagerImpl
implements XBreakpointManager,
PersistentStateComponent<BreakpointManagerState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl");
    public static final SkipDefaultValuesSerializationFilters SERIALIZATION_FILTER = new SkipDefaultValuesSerializationFilters();
    private final MultiValuesMap<XBreakpointType, XBreakpointBase<?, ?, ?>> myBreakpoints = new MultiValuesMap(true);
    private final Map<XBreakpointType, XBreakpointBase<?, ?, ?>> myDefaultBreakpoints = new LinkedHashMap();
    private final Map<XBreakpointType, BreakpointState<?, ?, ?>> myBreakpointsDefaults = new LinkedHashMap();
    private final Set<XBreakpointBase<?, ?, ?>> myAllBreakpoints = new HashSet();
    private final Map<XBreakpointType, EventDispatcher<XBreakpointListener>> myDispatchers = new HashMap<XBreakpointType, EventDispatcher<XBreakpointListener>>();
    private XBreakpointsDialogState myBreakpointsDialogSettings;
    private final EventDispatcher<XBreakpointListener> myAllBreakpointsDispatcher;
    private final XLineBreakpointManager myLineBreakpointManager;
    private final Project myProject;
    private final XDebuggerManagerImpl myDebuggerManager;
    private final XDependentBreakpointManager myDependentBreakpointManager;
    private long myTime;
    private String myDefaultGroup;

    public XBreakpointManagerImpl(Project project, XDebuggerManagerImpl debuggerManager, StartupManager startupManager) {
        this.myProject = project;
        this.myDebuggerManager = debuggerManager;
        this.myAllBreakpointsDispatcher = EventDispatcher.create(XBreakpointListener.class);
        this.myDependentBreakpointManager = new XDependentBreakpointManager(this);
        this.myLineBreakpointManager = new XLineBreakpointManager(project, this.myDependentBreakpointManager, startupManager);
        if (!project.isDefault()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                HttpVirtualFileListener httpVirtualFileListener = new HttpVirtualFileListener(){

                    public void fileDownloaded(@NotNull VirtualFile file2) {
                        if (file2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl$1", "fileDownloaded"));
                        }
                        XBreakpointManagerImpl.this.updateBreakpointInFile(file2);
                    }
                };
                HttpFileSystem.getInstance().addFileListener(httpVirtualFileListener, (Disposable)project);
            }
            for (XBreakpointType<?, ?> type : XBreakpointUtil.getBreakpointTypes()) {
                this.addDefaultBreakpoint(type);
            }
        }
    }

    private void updateBreakpointInFile(final VirtualFile file2) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                XBreakpointBase<?, ?, ?>[] breakpoints;
                for (XBreakpointBase<?, ?, ?> breakpoint : breakpoints = XBreakpointManagerImpl.this.getAllBreakpoints()) {
                    XSourcePosition position = breakpoint.getSourcePosition();
                    if (position == null || !Comparing.equal((Object)position.getFile(), (Object)file2)) continue;
                    XBreakpointManagerImpl.this.fireBreakpointChanged(breakpoint);
                }
            }
        });
    }

    public XLineBreakpointManager getLineBreakpointManager() {
        return this.myLineBreakpointManager;
    }

    public XDependentBreakpointManager getDependentBreakpointManager() {
        return this.myDependentBreakpointManager;
    }

    public XDebuggerManagerImpl getDebuggerManager() {
        return this.myDebuggerManager;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public <T extends XBreakpointProperties> XBreakpoint<T> addBreakpoint(XBreakpointType<XBreakpoint<T>, T> type, @Nullable T properties) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        XBreakpointBase<?, T, ?> breakpoint = this.createBreakpoint(type, properties, true, false);
        this.addBreakpoint(breakpoint, false, true);
        XBreakpointBase<?, T, ?> xBreakpointBase = breakpoint;
        if (xBreakpointBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "addBreakpoint"));
        }
        return xBreakpointBase;
    }

    private <T extends XBreakpointProperties> XBreakpointBase<?, T, ?> createBreakpoint(XBreakpointType<XBreakpoint<T>, T> type, T properties, boolean enabled, boolean defaultBreakpoint) {
        long l;
        String string = type.getId();
        if (defaultBreakpoint) {
            l = 0L;
        } else {
            long l2 = this.myTime;
            l = l2;
            this.myTime = l2 + 1L;
        }
        BreakpointState state = new BreakpointState(enabled, string, l);
        this.getBreakpointDefaults(type).applyDefaults(state);
        state.setGroup(this.myDefaultGroup);
        return new XBreakpointBase(type, this, properties, state);
    }

    private <T extends XBreakpointProperties> void addBreakpoint(XBreakpointBase<?, T, ?> breakpoint, boolean defaultBreakpoint, boolean initUI) {
        EventDispatcher<XBreakpointListener> dispatcher;
        XBreakpointType<?, T> type = breakpoint.getType();
        if (defaultBreakpoint) {
            LOG.assertTrue(!this.myDefaultBreakpoints.containsKey(type), (Object)("Cannot have more than one default breakpoint (type " + type.getId() + ")"));
            this.myDefaultBreakpoints.put(type, breakpoint);
        } else {
            this.myBreakpoints.put(type, breakpoint);
        }
        this.myAllBreakpoints.add(breakpoint);
        if (breakpoint instanceof XLineBreakpointImpl) {
            this.myLineBreakpointManager.registerBreakpoint((XLineBreakpointImpl)breakpoint, initUI);
        }
        if ((dispatcher = this.myDispatchers.get(type)) != null) {
            ((XBreakpointListener)dispatcher.getMulticaster()).breakpointAdded(breakpoint);
        }
        this.getBreakpointDispatcherMulticaster().breakpointAdded(breakpoint);
    }

    private XBreakpointListener<XBreakpoint<?>> getBreakpointDispatcherMulticaster() {
        return (XBreakpointListener)this.myAllBreakpointsDispatcher.getMulticaster();
    }

    public void fireBreakpointChanged(XBreakpointBase<?, ?, ?> breakpoint) {
        EventDispatcher<XBreakpointListener> dispatcher;
        if (!this.myAllBreakpoints.contains(breakpoint)) {
            return;
        }
        if (breakpoint instanceof XLineBreakpointImpl) {
            this.myLineBreakpointManager.breakpointChanged((XLineBreakpointImpl)breakpoint);
        }
        if ((dispatcher = this.myDispatchers.get(breakpoint.getType())) != null) {
            ((XBreakpointListener)dispatcher.getMulticaster()).breakpointChanged(breakpoint);
        }
        this.getBreakpointDispatcherMulticaster().breakpointChanged(breakpoint);
    }

    public void removeBreakpoint(@NotNull XBreakpoint<?> breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "removeBreakpoint"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.doRemoveBreakpoint(breakpoint);
    }

    private void doRemoveBreakpoint(XBreakpoint<?> breakpoint) {
        if (this.isDefaultBreakpoint(breakpoint)) {
            breakpoint.setEnabled(false);
        } else {
            XBreakpointType type = breakpoint.getType();
            XBreakpointBase breakpointBase = (XBreakpointBase)breakpoint;
            this.myBreakpoints.remove((Object)type, (Object)breakpointBase);
            this.myAllBreakpoints.remove(breakpointBase);
            if (breakpointBase instanceof XLineBreakpointImpl) {
                this.myLineBreakpointManager.unregisterBreakpoint((XLineBreakpointImpl)breakpointBase);
            }
            breakpointBase.dispose();
            EventDispatcher<XBreakpointListener> dispatcher = this.myDispatchers.get(type);
            if (dispatcher != null) {
                ((XBreakpointListener)dispatcher.getMulticaster()).breakpointRemoved(breakpoint);
            }
            this.getBreakpointDispatcherMulticaster().breakpointRemoved(breakpoint);
        }
    }

    @NotNull
    public <T extends XBreakpointProperties> XLineBreakpoint<T> addLineBreakpoint(XLineBreakpointType<T> type, @NotNull String fileUrl, int line, @Nullable T properties) {
        if (fileUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileUrl", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "addLineBreakpoint"));
        }
        XLineBreakpoint<T> xLineBreakpoint = this.addLineBreakpoint(type, fileUrl, line, properties, false);
        if (xLineBreakpoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "addLineBreakpoint"));
        }
        return xLineBreakpoint;
    }

    @NotNull
    public <T extends XBreakpointProperties> XLineBreakpoint<T> addLineBreakpoint(XLineBreakpointType<T> type, @NotNull String fileUrl, int line, @Nullable T properties, boolean temporary) {
        if (fileUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileUrl", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "addLineBreakpoint"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LineBreakpointState state = new LineBreakpointState(true, type.getId(), fileUrl, line, temporary, this.myTime++);
        this.getBreakpointDefaults((XBreakpointType)type).applyDefaults(state);
        state.setGroup(this.myDefaultGroup);
        XLineBreakpointImpl<T> breakpoint = new XLineBreakpointImpl<T>(type, this, properties, state);
        this.addBreakpoint(breakpoint, false, true);
        XLineBreakpointImpl<T> xLineBreakpointImpl = breakpoint;
        if (xLineBreakpointImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "addLineBreakpoint"));
        }
        return xLineBreakpointImpl;
    }

    @NotNull
    public XBreakpointBase<?, ?, ?>[] getAllBreakpoints() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        XBreakpointBase[] xBreakpointBaseArray = this.myAllBreakpoints.toArray(new XBreakpointBase[this.myAllBreakpoints.size()]);
        if (xBreakpointBaseArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "getAllBreakpoints"));
        }
        return xBreakpointBaseArray;
    }

    @NotNull
    public <B extends XBreakpoint<?>> Collection<? extends B> getBreakpoints(@NotNull XBreakpointType<B, ?> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "getBreakpoints"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection breakpoints = this.myBreakpoints.get(type);
        Collection regular = breakpoints != null ? Collections.unmodifiableCollection(breakpoints) : Collections.emptyList();
        XBreakpointBase<?, ?, ?> defaultBreakpoint = this.myDefaultBreakpoints.get(type);
        if (defaultBreakpoint == null) {
            Collection collection = regular;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "getBreakpoints"));
            }
            return collection;
        }
        ArrayList<XBreakpointBase<Object, Object, Object>> result2 = new ArrayList<XBreakpointBase<Object, Object, Object>>();
        result2.add(defaultBreakpoint);
        result2.addAll(regular);
        ArrayList<XBreakpointBase<Object, Object, Object>> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "getBreakpoints"));
        }
        return arrayList;
    }

    @NotNull
    public <B extends XBreakpoint<?>> Collection<? extends B> getBreakpoints(@NotNull Class<? extends XBreakpointType<B, ?>> typeClass) {
        if (typeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeClass", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "getBreakpoints"));
        }
        XBreakpointType type = XDebuggerUtil.getInstance().findBreakpointType(typeClass);
        LOG.assertTrue(type != null, (Object)("Unregistered breakpoint type " + typeClass));
        Collection<B> collection = this.getBreakpoints(type);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "getBreakpoints"));
        }
        return collection;
    }

    @Nullable
    public <B extends XBreakpoint<?>> B getDefaultBreakpoint(@NotNull XBreakpointType<B, ?> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "getDefaultBreakpoint"));
        }
        return (B)this.myDefaultBreakpoints.get(type);
    }

    @Nullable
    public <P extends XBreakpointProperties> XLineBreakpoint<P> findBreakpointAtLine(@NotNull XLineBreakpointType<P> type, @NotNull VirtualFile file2, int line) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "findBreakpointAtLine"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "findBreakpointAtLine"));
        }
        Collection breakpoints = this.myBreakpoints.get(type);
        if (breakpoints == null) {
            return null;
        }
        for (XBreakpointBase breakpoint : breakpoints) {
            XLineBreakpoint lineBreakpoint = (XLineBreakpoint)breakpoint;
            if (!lineBreakpoint.getFileUrl().equals(file2.getUrl()) || lineBreakpoint.getLine() != line) continue;
            return lineBreakpoint;
        }
        return null;
    }

    public boolean isDefaultBreakpoint(@NotNull XBreakpoint<?> breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "isDefaultBreakpoint"));
        }
        return this.myDefaultBreakpoints.values().contains(breakpoint);
    }

    private <T extends XBreakpointProperties> EventDispatcher<XBreakpointListener> getOrCreateDispatcher(XBreakpointType<?, T> type) {
        EventDispatcher dispatcher = this.myDispatchers.get(type);
        if (dispatcher == null) {
            dispatcher = EventDispatcher.create(XBreakpointListener.class);
            this.myDispatchers.put(type, (EventDispatcher<XBreakpointListener>)dispatcher);
        }
        return dispatcher;
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void addBreakpointListener(@NotNull XBreakpointType<B, P> type, @NotNull XBreakpointListener<B> listener) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "addBreakpointListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "addBreakpointListener"));
        }
        this.getOrCreateDispatcher(type).addListener(listener);
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void removeBreakpointListener(@NotNull XBreakpointType<B, P> type, @NotNull XBreakpointListener<B> listener) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "removeBreakpointListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "removeBreakpointListener"));
        }
        this.getOrCreateDispatcher(type).removeListener(listener);
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void addBreakpointListener(@NotNull XBreakpointType<B, P> type, @NotNull XBreakpointListener<B> listener, Disposable parentDisposable) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "addBreakpointListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "addBreakpointListener"));
        }
        this.getOrCreateDispatcher(type).addListener(listener, parentDisposable);
    }

    public void addBreakpointListener(@NotNull XBreakpointListener<XBreakpoint<?>> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "addBreakpointListener"));
        }
        this.myAllBreakpointsDispatcher.addListener(listener);
    }

    public void removeBreakpointListener(@NotNull XBreakpointListener<XBreakpoint<?>> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "removeBreakpointListener"));
        }
        this.myAllBreakpointsDispatcher.removeListener(listener);
    }

    public void addBreakpointListener(@NotNull XBreakpointListener<XBreakpoint<?>> listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "addBreakpointListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "addBreakpointListener"));
        }
        this.myAllBreakpointsDispatcher.addListener(listener, parentDisposable);
    }

    public void updateBreakpointPresentation(@NotNull XLineBreakpoint<?> breakpoint, @Nullable Icon icon, @Nullable String errorMessage) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "updateBreakpointPresentation"));
        }
        XLineBreakpointImpl lineBreakpoint = (XLineBreakpointImpl)breakpoint;
        CustomizedBreakpointPresentation presentation = lineBreakpoint.getCustomizedPresentation();
        if (presentation == null) {
            if (icon == null && errorMessage == null) {
                return;
            }
            presentation = new CustomizedBreakpointPresentation();
        } else if (Comparing.equal((Object)presentation.getIcon(), (Object)icon) && Comparing.strEqual((String)presentation.getErrorMessage(), (String)errorMessage)) {
            return;
        }
        presentation.setErrorMessage(errorMessage);
        presentation.setIcon(icon);
        lineBreakpoint.setCustomizedPresentation(presentation);
        this.myLineBreakpointManager.queueBreakpointUpdate((XBreakpoint<?>)breakpoint);
    }

    public BreakpointManagerState getState() {
        this.myDependentBreakpointManager.saveState();
        BreakpointManagerState state = new BreakpointManagerState();
        for (XBreakpointBase<?, ?, ?> xBreakpointBase : this.myDefaultBreakpoints.values()) {
            Object breakpointState = xBreakpointBase.getState();
            if (!this.differsFromDefault((XBreakpointType)xBreakpointBase.getType(), (BreakpointState)breakpointState)) continue;
            state.getDefaultBreakpoints().add((BreakpointState)breakpointState);
        }
        for (XBreakpointBase<Object, Object, Object> xBreakpointBase : this.myBreakpoints.values()) {
            state.getBreakpoints().add((BreakpointState)xBreakpointBase.getState());
        }
        for (Map.Entry entry : this.myBreakpointsDefaults.entrySet()) {
            if (!XBreakpointManagerImpl.statesAreDifferent((BreakpointState)entry.getValue(), XBreakpointManagerImpl.createBreakpointDefaults((XBreakpointType)entry.getKey()))) continue;
            state.getBreakpointsDefaults().add((BreakpointState)entry.getValue());
        }
        state.setBreakpointsDialogProperties(this.myBreakpointsDialogSettings);
        state.setTime(this.myTime);
        state.setDefaultGroup(this.myDefaultGroup);
        return state;
    }

    private <P extends XBreakpointProperties> boolean differsFromDefault(XBreakpointType<?, P> type, BreakpointState state) {
        XBreakpoint<P> defaultBreakpoint = this.createDefaultBreakpoint(type);
        if (defaultBreakpoint == null) {
            return false;
        }
        Object defaultState = ((XBreakpointBase)defaultBreakpoint).getState();
        return XBreakpointManagerImpl.statesAreDifferent(state, defaultState);
    }

    private static boolean statesAreDifferent(BreakpointState state1, BreakpointState state2) {
        Element elem2;
        Element elem1 = XmlSerializer.serialize((Object)state1, (SerializationFilter)SERIALIZATION_FILTER);
        return !JDOMUtil.areElementsEqual((Element)elem1, (Element)(elem2 = XmlSerializer.serialize((Object)state2, (SerializationFilter)SERIALIZATION_FILTER)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(BreakpointManagerState state) {
        this.myBreakpointsDialogSettings = state.getBreakpointsDialogProperties();
        this.myAllBreakpoints.clear();
        this.myDefaultBreakpoints.clear();
        this.myBreakpointsDefaults.clear();
        AccessToken token = ReadAction.start();
        try {
            for (BreakpointState breakpointState : state.getDefaultBreakpoints()) {
                this.loadBreakpoint(breakpointState, true);
            }
            for (XBreakpointType<?, ?> type : XBreakpointUtil.getBreakpointTypes()) {
                if (this.myDefaultBreakpoints.containsKey(type)) continue;
                this.addDefaultBreakpoint(type);
            }
            for (XBreakpointBase breakpoint : this.myBreakpoints.values()) {
                this.doRemoveBreakpoint(breakpoint);
            }
            for (BreakpointState breakpointState : state.getBreakpoints()) {
                this.loadBreakpoint(breakpointState, false);
            }
            for (BreakpointState defaults : state.getBreakpointsDefaults()) {
                XBreakpointType<?, ?> type = XBreakpointUtil.findType(defaults.getTypeId());
                if (type != null) {
                    this.myBreakpointsDefaults.put(type, defaults);
                    continue;
                }
                LOG.warn("Unknown breakpoint type " + defaults.getTypeId());
            }
            this.myDependentBreakpointManager.loadState();
        }
        finally {
            token.finish();
        }
        this.myLineBreakpointManager.updateBreakpointsUI();
        this.myTime = state.getTime();
        this.myDefaultGroup = state.getDefaultGroup();
    }

    private <P extends XBreakpointProperties> void addDefaultBreakpoint(XBreakpointType<?, P> type) {
        XBreakpoint<P> breakpoint = this.createDefaultBreakpoint(type);
        if (breakpoint != null) {
            this.addBreakpoint((XBreakpointBase)breakpoint, true, false);
        }
    }

    @Nullable
    private <P extends XBreakpointProperties> XBreakpoint<P> createDefaultBreakpoint(final XBreakpointType<? extends XBreakpoint<P>, P> type) {
        return type.createDefaultBreakpoint(new XBreakpointType.XBreakpointCreator<P>(){

            @NotNull
            public XBreakpoint<P> createBreakpoint(@Nullable P properties) {
                XBreakpointBase xBreakpointBase = XBreakpointManagerImpl.this.createBreakpoint(type, properties, false, true);
                if (xBreakpointBase == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl$3", "createBreakpoint"));
                }
                return xBreakpointBase;
            }
        });
    }

    private void loadBreakpoint(BreakpointState breakpointState, boolean defaultBreakpoint) {
        XBreakpointBase<?, ?, ?> breakpoint = this.createBreakpoint(breakpointState);
        if (breakpoint != null) {
            this.addBreakpoint(breakpoint, defaultBreakpoint, false);
        }
    }

    public XBreakpointsDialogState getBreakpointsDialogSettings() {
        return this.myBreakpointsDialogSettings;
    }

    public void setBreakpointsDialogSettings(XBreakpointsDialogState breakpointsDialogSettings) {
        this.myBreakpointsDialogSettings = breakpointsDialogSettings;
    }

    public Set<String> getAllGroups() {
        HashSet<String> res = new HashSet<String>();
        for (XBreakpointBase<?, ?, ?> breakpoint : this.myAllBreakpoints) {
            String group = breakpoint.getGroup();
            if (group == null) continue;
            res.add(group);
        }
        return res;
    }

    public String getDefaultGroup() {
        return this.myDefaultGroup;
    }

    public void setDefaultGroup(String defaultGroup) {
        this.myDefaultGroup = defaultGroup;
    }

    @Nullable
    private XBreakpointBase<?, ?, ?> createBreakpoint(BreakpointState breakpointState) {
        XBreakpointType<?, ?> type = XBreakpointUtil.findType(breakpointState.getTypeId());
        if (type == null) {
            LOG.warn("Unknown breakpoint type " + breakpointState.getTypeId());
            return null;
        }
        return breakpointState.createBreakpoint(type, this);
    }

    @NotNull
    public BreakpointState getBreakpointDefaults(@NotNull XBreakpointType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "getBreakpointDefaults"));
        }
        BreakpointState defaultState = this.myBreakpointsDefaults.get(type);
        if (defaultState == null) {
            defaultState = XBreakpointManagerImpl.createBreakpointDefaults(type);
            this.myBreakpointsDefaults.put(type, defaultState);
        }
        BreakpointState breakpointState = defaultState;
        if (breakpointState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "getBreakpointDefaults"));
        }
        return breakpointState;
    }

    @NotNull
    private static BreakpointState createBreakpointDefaults(@NotNull XBreakpointType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "createBreakpointDefaults"));
        }
        BreakpointState state = new BreakpointState();
        state.setTypeId(type.getId());
        BreakpointState breakpointState = state;
        if (breakpointState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl", "createBreakpointDefaults"));
        }
        return breakpointState;
    }

    @Tag(value="breakpoint-manager")
    public static class BreakpointManagerState {
        private List<BreakpointState> myDefaultBreakpoints = new ArrayList<BreakpointState>();
        private List<BreakpointState> myBreakpoints = new ArrayList<BreakpointState>();
        private List<BreakpointState> myBreakpointsDefaults = new ArrayList<BreakpointState>();
        private XBreakpointsDialogState myBreakpointsDialogProperties;
        private long myTime;
        private String myDefaultGroup;

        @Tag(value="default-breakpoints")
        @AbstractCollection(surroundWithTag=false)
        public List<BreakpointState> getDefaultBreakpoints() {
            return this.myDefaultBreakpoints;
        }

        @Tag(value="breakpoints")
        @AbstractCollection(surroundWithTag=false, elementTypes={BreakpointState.class, LineBreakpointState.class})
        public List<BreakpointState> getBreakpoints() {
            return this.myBreakpoints;
        }

        @Tag(value="breakpoints-defaults")
        @AbstractCollection(surroundWithTag=false, elementTypes={BreakpointState.class, LineBreakpointState.class})
        public List<BreakpointState> getBreakpointsDefaults() {
            return this.myBreakpointsDefaults;
        }

        @Tag(value="breakpoints-dialog")
        public XBreakpointsDialogState getBreakpointsDialogProperties() {
            return this.myBreakpointsDialogProperties;
        }

        public void setBreakpoints(List<BreakpointState> breakpoints) {
            this.myBreakpoints = breakpoints;
        }

        public void setDefaultBreakpoints(List<BreakpointState> defaultBreakpoints) {
            this.myDefaultBreakpoints = defaultBreakpoints;
        }

        public void setBreakpointsDefaults(List<BreakpointState> breakpointsDefaults) {
            this.myBreakpointsDefaults = breakpointsDefaults;
        }

        public void setBreakpointsDialogProperties(XBreakpointsDialogState breakpointsDialogProperties) {
            this.myBreakpointsDialogProperties = breakpointsDialogProperties;
        }

        public long getTime() {
            return this.myTime;
        }

        public void setTime(long time) {
            this.myTime = time;
        }

        public String getDefaultGroup() {
            return this.myDefaultGroup;
        }

        public void setDefaultGroup(String defaultGroup) {
            this.myDefaultGroup = defaultGroup;
        }
    }
}

