/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.table;

import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.table.JBTableRow;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public abstract class JBListTableModel
extends AbstractTableModel
implements EditableModel {
    private final TableModel myModel;

    public JBListTableModel(TableModel model) {
        this.myModel = model;
    }

    @Override
    public int getRowCount() {
        return this.myModel.getRowCount();
    }

    @Override
    public final int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public abstract JBTableRow getRow(int var1);

    @Override
    public final JBTableRow getValueAt(int rowIndex, int columnIndex) {
        return this.getRow(rowIndex);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        for (int i = 0; i < this.myModel.getColumnCount(); ++i) {
            this.myModel.setValueAt(((JBTableRow)value).getValueAt(i), row, i);
        }
        this.fireTableCellUpdated(row, column);
    }

    public void addRow() {
        int count = this.myModel.getRowCount();
        if (this.myModel instanceof EditableModel) {
            ((EditableModel)this.myModel).addRow();
        }
        if (count < this.myModel.getRowCount()) {
            this.fireTableRowsInserted(count, this.myModel.getRowCount() - 1);
        }
    }

    public void removeRow(int index) {
        if (this.myModel instanceof EditableModel) {
            ((EditableModel)this.myModel).removeRow(index);
        }
        this.fireTableRowsDeleted(index, index);
    }

    public boolean canExchangeRows(int oldIndex, int newIndex) {
        if (this.myModel instanceof EditableModel) {
            return ((EditableModel)this.myModel).canExchangeRows(oldIndex, newIndex);
        }
        return false;
    }

    public void exchangeRows(int oldIndex, int newIndex) {
        if (this.myModel instanceof EditableModel) {
            ((EditableModel)this.myModel).exchangeRows(oldIndex, newIndex);
        }
        this.fireTableRowsUpdated(Math.min(oldIndex, newIndex), Math.max(oldIndex, newIndex));
    }
}

