/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.lookup.LookupAdapter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.popup.PopupUpdateProcessorBase;
import java.awt.Component;
import javax.swing.JComponent;

public abstract class PopupUpdateProcessor
extends PopupUpdateProcessorBase {
    private final Project myProject;

    protected PopupUpdateProcessor(Project project) {
        this.myProject = project;
    }

    public void beforeShown(final LightweightWindowEvent windowEvent) {
        final LookupEx activeLookup = LookupManager.getInstance(this.myProject).getActiveLookup();
        if (activeLookup != null) {
            activeLookup.addLookupListener(new LookupAdapter(){

                @Override
                public void currentItemChanged(LookupEvent event) {
                    if (windowEvent.asPopup().isVisible()) {
                        LookupElement item = event.getItem();
                        if (item != null) {
                            PsiElement targetElement = CompletionUtil.getTargetElement(item);
                            if (targetElement == null) {
                                targetElement = DocumentationManager.getInstance(PopupUpdateProcessor.this.myProject).getElementFromLookup(activeLookup.getEditor(), activeLookup.getPsiFile());
                            }
                            PopupUpdateProcessor.this.updatePopup(targetElement);
                        }
                    } else {
                        activeLookup.removeLookupListener((LookupListener)this);
                    }
                }
            });
        } else {
            HintUpdateSupply supply;
            boolean fromQuickSearch;
            Component focusedComponent = WindowManagerEx.getInstanceEx().getFocusedComponent(this.myProject);
            boolean bl = fromQuickSearch = focusedComponent != null && focusedComponent.getParent() instanceof ChooseByNameBase.JPanelProvider;
            if (fromQuickSearch) {
                ChooseByNameBase.JPanelProvider panelProvider = (ChooseByNameBase.JPanelProvider)focusedComponent.getParent();
                panelProvider.registerHint(windowEvent.asPopup());
            } else if (focusedComponent instanceof JComponent && (supply = HintUpdateSupply.getSupply((JComponent)((JComponent)focusedComponent))) != null) {
                supply.registerHint(windowEvent.asPopup());
            }
        }
    }
}

