/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.SimpleActionGroup;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolAction;
import com.intellij.tools.ToolsGroup;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class BaseExternalToolsGroup<T extends Tool>
extends SimpleActionGroup
implements DumbAware {
    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        this.removeAll();
        String context = event.getPlace();
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            presentation.setVisible(false);
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(true);
        List<ToolsGroup<T>> groups = this.getToolsGroups();
        for (ToolsGroup<T> group : groups) {
            String groupName = group.getName();
            if (!StringUtil.isEmptyOrSpaces((String)groupName)) {
                SimpleActionGroup subgroup = new SimpleActionGroup();
                subgroup.getTemplatePresentation().setText(groupName, false);
                subgroup.setPopup(true);
                this.fillGroup(context, groupName, subgroup);
                if (subgroup.getChildrenCount() <= 0) continue;
                this.add((AnAction)subgroup);
                continue;
            }
            this.fillGroup(context, null, this);
        }
        presentation.setVisible(this.getChildrenCount() > 0);
    }

    protected abstract List<ToolsGroup<T>> getToolsGroups();

    private void fillGroup(String context, @Nullable String groupName, SimpleActionGroup group) {
        List<T> tools = this.getToolsByGroupName(groupName);
        for (Tool tool : tools) {
            if (!this.isToolVisible(tool, context)) continue;
            this.addToolToGroup(tool, group);
        }
    }

    protected abstract List<T> getToolsByGroupName(String var1);

    private void addToolToGroup(T tool, SimpleActionGroup group) {
        String id = ((Tool)tool).getActionId();
        AnAction action = ActionManager.getInstance().getAction(id);
        if (action == null) {
            action = this.createToolAction(tool);
        }
        group.add(action);
    }

    protected abstract ToolAction createToolAction(T var1);

    private boolean isToolVisible(T tool, String context) {
        if (!((Tool)tool).isEnabled()) {
            return false;
        }
        if ("EditorPopup".equals(context) || "EditorTabPopup".equals(context)) {
            return ((Tool)tool).isShownInEditor();
        }
        if ("ProjectViewPopup".equals(context) || "CommanderPopup".equals(context) || "J2EEViewPopup".equals(context) || "TypeHierarchyViewPopup".equals(context) || "CallHierarchyViewPopup".equals(context) || "MethodHierarchyViewPopup".equals(context) || "FavoritesPopup".equals(context) || "ScopeViewPopup".equals(context) || "NavBar".equals(context)) {
            return ((Tool)tool).isShownInProjectViews();
        }
        if (ActionPlaces.isMainMenuOrActionSearch((String)context)) {
            return ((Tool)tool).isShownInMainMenu();
        }
        if ("UsageViewPopup".equals(context)) {
            return ((Tool)tool).isShownInSearchResultsPopup();
        }
        return false;
    }
}

