/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPullUp;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.memberPullUp.PullUpConflictsUtil;
import com.intellij.refactoring.memberPullUp.PullUpDialog;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.classMembers.MemberInfoStorage;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaPullUpHandler
implements RefactoringActionHandler,
PullUpDialog.Callback,
ElementsHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.memberPullUp.JavaPullUpHandler");
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"pull.members.up.title");
    private PsiClass mySubclass;
    private Project myProject;

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/memberPullUp/JavaPullUpHandler", "invoke"));
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file2.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.pull.members.from"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.pullMembersUp");
                return;
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)element)) {
                return;
            }
            if (element instanceof PsiClass || element instanceof PsiField || element instanceof PsiMethod) {
                this.invoke(project, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        PsiClass aClass;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/memberPullUp/JavaPullUpHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/memberPullUp/JavaPullUpHandler", "invoke"));
        }
        if (elements.length != 1) {
            return;
        }
        this.myProject = project;
        PsiElement element = elements[0];
        PsiElement aMember = null;
        if (element instanceof PsiClass) {
            aClass = (PsiClass)element;
        } else if (element instanceof PsiMethod) {
            aClass = ((PsiMethod)element).getContainingClass();
            aMember = element;
        } else if (element instanceof PsiField) {
            aClass = ((PsiField)element).getContainingClass();
            aMember = element;
        } else {
            return;
        }
        this.invoke(project, dataContext, aClass, aMember);
    }

    private void invoke(Project project, DataContext dataContext, PsiClass aClass, PsiElement aMember) {
        Editor editor;
        Editor editor2 = editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        if (aClass == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{REFACTORING_NAME}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.pullMembersUp");
            return;
        }
        ArrayList<PsiClass> bases = RefactoringHierarchyUtil.createBasesList(aClass, false, true);
        if (bases.isEmpty()) {
            PsiClass containingClass = aClass.getContainingClass();
            if (containingClass != null) {
                this.invoke(project, dataContext, containingClass, (PsiElement)aClass);
                return;
            }
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"class.does.not.have.base.classes.interfaces.in.current.project", (Object[])new Object[]{aClass.getQualifiedName()}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.pullMembersUp");
            return;
        }
        this.mySubclass = aClass;
        MemberInfoStorage memberInfoStorage = new MemberInfoStorage(this.mySubclass, new MemberInfoBase.Filter<PsiMember>(){

            public boolean includeMember(PsiMember element) {
                return true;
            }
        });
        List members = memberInfoStorage.getClassMemberInfos(this.mySubclass);
        PsiManager manager = this.mySubclass.getManager();
        for (MemberInfoBase member : members) {
            if (!manager.areElementsEquivalent(member.getMember(), aMember)) continue;
            member.setChecked(true);
            break;
        }
        PullUpDialog dialog = new PullUpDialog(project, aClass, bases, memberInfoStorage, this);
        dialog.show();
    }

    @Override
    public boolean checkConflicts(final PullUpDialog dialog) {
        List infos = dialog.getSelectedMemberInfos();
        final MemberInfo[] memberInfos = infos.toArray(new MemberInfo[infos.size()]);
        final PsiClass superClass = (PsiClass)dialog.getSuperClass();
        if (!this.checkWritable(superClass, memberInfos)) {
            return false;
        }
        final MultiMap conflicts = new MultiMap();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        PsiDirectory targetDirectory = superClass.getContainingFile().getContainingDirectory();
                        PsiPackage targetPackage = targetDirectory != null ? JavaDirectoryService.getInstance().getPackage(targetDirectory) : null;
                        conflicts.putAllValues(PullUpConflictsUtil.checkConflicts(memberInfos, JavaPullUpHandler.this.mySubclass, superClass, targetPackage, targetDirectory, dialog.getContainmentVerifier()));
                    }
                });
            }
        }, RefactoringBundle.message((String)"detecting.possible.conflicts"), true, this.myProject)) {
            return false;
        }
        if (!conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(this.myProject, (MultiMap<PsiElement, String>)conflicts);
            conflictsDialog.show();
            boolean ok = conflictsDialog.isOK();
            if (!ok && conflictsDialog.isShowConflicts()) {
                dialog.close(1);
            }
            return ok;
        }
        return true;
    }

    private boolean checkWritable(PsiClass superClass, MemberInfo[] infos) {
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)superClass)) {
            return false;
        }
        for (MemberInfo info : infos) {
            if (info.getMember() instanceof PsiClass && info.getOverrides() != null || CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)info.getMember())) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && elements[0] instanceof PsiClass;
    }
}

