/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class XmlAttributeManipulator
extends AbstractElementManipulator<XmlAttribute> {
    private static final Logger LOG = Logger.getInstance(XmlAttributeManipulator.class);

    public XmlAttribute handleContentChange(@NotNull XmlAttribute attribute, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlAttributeManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlAttributeManipulator", "handleContentChange"));
        }
        String attr = attribute.getText();
        ASTNode astNode = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(attribute.getNode());
        assert (astNode != null);
        PsiElement namePsi = astNode.getPsi();
        int startOffsetInParent = namePsi.getStartOffsetInParent();
        TextRange nameRange = new TextRange(startOffsetInParent, startOffsetInParent + namePsi.getTextLength());
        if (nameRange.contains(range)) {
            String content = attr.substring(0, range.getStartOffset()) + newContent + attr.substring(range.getEndOffset(), nameRange.getEndOffset());
            attribute.setName(content);
        } else {
            XmlAttributeValue value = attribute.getValueElement();
            if (value == null) {
                assert (range.getStartOffset() == 0 && range.getEndOffset() == 0);
                attribute.setValue(newContent);
                return attribute;
            }
            StringBuilder replacement = new StringBuilder(value.getText());
            int offset = value.getTextRange().getStartOffset() - attribute.getTextRange().getStartOffset();
            replacement.replace(range.getStartOffset() - offset, range.getEndOffset() - offset, newContent);
            attribute.setValue(replacement.toString());
        }
        return attribute;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlAttributeManipulator", "getRangeInElement"));
        }
        XmlAttributeValue value = attribute.getValueElement();
        if (value == null) {
            TextRange textRange = TextRange.from((int)0, (int)0);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlAttributeManipulator", "getRangeInElement"));
            }
            return textRange;
        }
        TextRange range = attribute.getValueTextRange();
        if (range == null) {
            LOG.error("Null range in " + attribute + " '" + attribute.getText() + "'");
        }
        TextRange textRange = range.shiftRight(value.getStartOffsetInParent());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlAttributeManipulator", "getRangeInElement"));
        }
        return textRange;
    }
}

