/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.smartPointers.FileElementInfo;
import com.intellij.psi.impl.smartPointers.InjectedSelfElementInfo;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import org.jetbrains.annotations.NotNull;

class SmartPsiFileRangePointerImpl
extends SmartPsiElementPointerImpl<PsiFile>
implements SmartPsiFileRange {
    SmartPsiFileRangePointerImpl(@NotNull PsiFile containingFile, @NotNull ProperTextRange range, boolean forInjected) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl", "<init>"));
        }
        super(containingFile, SmartPsiFileRangePointerImpl.createElementInfo(containingFile, range, forInjected), PsiFile.class);
    }

    @NotNull
    private static SmartPointerElementInfo createElementInfo(@NotNull PsiFile containingFile, @NotNull ProperTextRange range, boolean forInjected) {
        PsiLanguageInjectionHost host;
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl", "createElementInfo"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl", "createElementInfo"));
        }
        Project project = containingFile.getProject();
        if (containingFile.getViewProvider() instanceof FreeThreadedFileViewProvider && (host = InjectedLanguageManager.getInstance((Project)project).getInjectionHost((PsiElement)containingFile)) != null) {
            SmartPsiElementPointer hostPointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)host);
            InjectedSelfElementInfo injectedSelfElementInfo = new InjectedSelfElementInfo(project, (PsiElement)containingFile, (TextRange)range, containingFile, (SmartPsiElementPointer<PsiLanguageInjectionHost>)hostPointer);
            if (injectedSelfElementInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl", "createElementInfo"));
            }
            return injectedSelfElementInfo;
        }
        if (range.equals((Object)containingFile.getTextRange())) {
            FileElementInfo fileElementInfo = new FileElementInfo(containingFile);
            if (fileElementInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl", "createElementInfo"));
            }
            return fileElementInfo;
        }
        SelfElementInfo selfElementInfo = new SelfElementInfo(project, range, PsiElement.class, containingFile, containingFile.getLanguage(), forInjected);
        if (selfElementInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl", "createElementInfo"));
        }
        return selfElementInfo;
    }

    @Override
    public PsiFile getElement() {
        if (this.getRange() == null) {
            return null;
        }
        return this.getContainingFile();
    }

    @Override
    public String toString() {
        return "SmartPsiFileRangePointerImpl{" + this.getElementInfo() + "}";
    }
}

