/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.beanProperties;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.ArrayUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanPropertyElement
extends FakePsiElement
implements PsiMetaOwner,
PsiPresentableMetaData {
    private final PsiMethod myMethod;
    private final String myName;

    public BeanPropertyElement(@NotNull PsiMethod method, @NotNull String name) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/beanProperties/BeanPropertyElement", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/beanProperties/BeanPropertyElement", "<init>"));
        }
        this.myMethod = method;
        this.myName = name;
    }

    @Nullable
    public PsiType getPropertyType() {
        return PropertyUtil.getPropertyType((PsiMember)this.myMethod);
    }

    @NotNull
    public PsiMethod getMethod() {
        PsiMethod psiMethod = this.myMethod;
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/beanProperties/BeanPropertyElement", "getMethod"));
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiMethod psiMethod = this.myMethod;
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/beanProperties/BeanPropertyElement", "getNavigationElement"));
        }
        return psiMethod;
    }

    @Override
    public PsiManager getManager() {
        return this.myMethod.getManager();
    }

    public PsiElement getDeclaration() {
        return this;
    }

    @NonNls
    public String getName(PsiElement context) {
        return this.getName();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/beanProperties/BeanPropertyElement", "getName"));
        }
        return string;
    }

    public void init(PsiElement element) {
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @Nullable
    public Icon getIcon(boolean flags) {
        return AllIcons.Nodes.Property;
    }

    public PsiElement getParent() {
        return this.myMethod;
    }

    @Nullable
    public PsiMetaData getMetaData() {
        return this;
    }

    public String getTypeName() {
        return IdeBundle.message((String)"bean.property", (Object[])new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return this.getIcon(0);
    }

    @Override
    public TextRange getTextRange() {
        return TextRange.from((int)0, (int)0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BeanPropertyElement element = (BeanPropertyElement)((Object)o);
        if (!this.myMethod.equals(element.myMethod)) {
            return false;
        }
        return this.myName.equals(element.myName);
    }

    public int hashCode() {
        int result2 = this.myMethod.hashCode();
        result2 = 31 * result2 + this.myName.hashCode();
        return result2;
    }
}

