/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.ide.IconProvider;
import com.intellij.ide.TypePresentationService;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomIconProvider;
import com.intellij.pom.PomNamedTarget;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PomTargetPsiElementImpl
extends RenameableFakePsiElement
implements PomTargetPsiElement {
    private final PomTarget myTarget;
    private final Project myProject;

    public PomTargetPsiElementImpl(@NotNull PsiTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/psi/impl/PomTargetPsiElementImpl", "<init>"));
        }
        this(target.getNavigationElement().getProject(), (PomTarget)target);
    }

    public PomTargetPsiElementImpl(@NotNull Project project, @NotNull PomTarget target) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/PomTargetPsiElementImpl", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/psi/impl/PomTargetPsiElementImpl", "<init>"));
        }
        super(null);
        this.myProject = project;
        this.myTarget = target;
    }

    @NotNull
    public PomTarget getTarget() {
        PomTarget pomTarget = this.myTarget;
        if (pomTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PomTargetPsiElementImpl", "getTarget"));
        }
        return pomTarget;
    }

    @Override
    public String getName() {
        if (this.myTarget instanceof PomNamedTarget) {
            return ((PomNamedTarget)this.myTarget).getName();
        }
        return null;
    }

    @Override
    public boolean isWritable() {
        if (this.myTarget instanceof PomRenameableTarget) {
            return ((PomRenameableTarget)this.myTarget).isWritable();
        }
        return false;
    }

    public String getTypeName() {
        throw new UnsupportedOperationException("Method getTypeName is not yet implemented for " + this.myTarget.getClass().getName() + "; see PomDescriptionProvider");
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        if (this.myTarget instanceof PsiTarget) {
            PsiElement psiElement = ((PsiTarget)this.myTarget).getNavigationElement();
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PomTargetPsiElementImpl", "getNavigationElement"));
            }
            return psiElement;
        }
        PsiElement psiElement = super.getNavigationElement();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PomTargetPsiElementImpl", "getNavigationElement"));
        }
        return psiElement;
    }

    public Icon getIcon() {
        for (IconProvider iconProvider : (IconProvider[])IconProvider.EXTENSION_POINT_NAME.getExtensions()) {
            Icon icon;
            if (!(iconProvider instanceof PomIconProvider) || (icon = ((PomIconProvider)iconProvider).getIcon(this.myTarget, 0)) == null) continue;
            return icon;
        }
        Icon icon = TypePresentationService.getService().getIcon((Object)this.myTarget);
        if (icon != null) {
            return icon;
        }
        if (this.myTarget instanceof PsiTarget) {
            return ((PsiTarget)this.myTarget).getNavigationElement().getIcon(0);
        }
        return null;
    }

    @Override
    public boolean isValid() {
        if (this.myTarget instanceof PsiTarget) {
            return ((PsiTarget)this.myTarget).getNavigationElement().isValid();
        }
        return this.myTarget.isValid();
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/PomTargetPsiElementImpl", "setName"));
        }
        if (this.myTarget instanceof PomRenameableTarget) {
            ((PomRenameableTarget)this.myTarget).setName(name);
            return this;
        }
        throw new UnsupportedOperationException("Cannot rename " + this.myTarget);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PomTargetPsiElementImpl that = (PomTargetPsiElementImpl)((Object)o);
        return this.myTarget.equals(that.myTarget);
    }

    public int hashCode() {
        return this.myTarget.hashCode();
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return this.equals(another) || another != null && this.myTarget instanceof PsiTarget && another.isEquivalentTo(((PsiTarget)this.myTarget).getNavigationElement());
    }

    @Override
    public PsiElement getContext() {
        if (this.myTarget instanceof PsiTarget) {
            return ((PsiTarget)this.myTarget).getNavigationElement();
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement getParent() {
        return null;
    }

    @Override
    public void navigate(boolean requestFocus) {
        this.myTarget.navigate(requestFocus);
    }

    @Override
    public boolean canNavigate() {
        return this.myTarget.canNavigate();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.myTarget.canNavigateToSource();
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        if (this.myTarget instanceof PsiTarget) {
            return ((PsiTarget)this.myTarget).getNavigationElement().getContainingFile();
        }
        return null;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        if (this.myTarget instanceof PsiTarget) {
            Language language = ((PsiTarget)this.myTarget).getNavigationElement().getLanguage();
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PomTargetPsiElementImpl", "getLanguage"));
            }
            return language;
        }
        Language language = Language.ANY;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PomTargetPsiElementImpl", "getLanguage"));
        }
        return language;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PomTargetPsiElementImpl", "getProject"));
        }
        return project;
    }

    @Override
    public String getLocationString() {
        PsiFile file2;
        if (this.myTarget instanceof PsiTarget && (file2 = ((PsiTarget)this.myTarget).getNavigationElement().getContainingFile()) != null) {
            return "(" + file2.getName() + ")";
        }
        return super.getLocationString();
    }
}

