/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.HierarchicalFilePathComparator;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class ChangesComparator
implements Comparator<Change> {
    private static final ChangesComparator ourFlattenedInstance = new ChangesComparator(false);
    private static final ChangesComparator ourTreeInstance = new ChangesComparator(true);
    @NotNull
    private final HierarchicalFilePathComparator myFilePathComparator;
    private final boolean myTreeCompare;

    public static ChangesComparator getInstance(boolean flattened) {
        if (flattened) {
            return ourFlattenedInstance;
        }
        return ourTreeInstance;
    }

    private ChangesComparator(boolean treeCompare) {
        this.myTreeCompare = treeCompare;
        this.myFilePathComparator = HierarchicalFilePathComparator.IGNORE_CASE;
    }

    @Override
    public int compare(Change o1, Change o2) {
        FilePath filePath1 = ChangesUtil.getFilePath((Change)o1);
        FilePath filePath2 = ChangesUtil.getFilePath((Change)o2);
        if (this.myTreeCompare) {
            return this.myFilePathComparator.compare(filePath1, filePath2);
        }
        return filePath1.getName().compareToIgnoreCase(filePath2.getName());
    }
}

