/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.UnversionedViewDialog;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.SimpleTextAttributes;

public class ChangesBrowserManyUnversionedFilesNode
extends ChangesBrowserNode {
    private final Project myProject;
    private final int myUnversionedSize;
    private final int myDirsSize;
    private final MyUnversionedShower myShower;

    public ChangesBrowserManyUnversionedFilesNode(Project project, int unversionedSize, int dirsSize) {
        super(UNVERSIONED_FILES_TAG);
        this.myProject = project;
        this.myUnversionedSize = unversionedSize;
        this.myDirsSize = dirsSize;
        this.myShower = new MyUnversionedShower(this.myProject);
    }

    @Override
    public boolean canAcceptDrop(ChangeListDragBean dragBean) {
        return false;
    }

    @Override
    public void acceptDrop(ChangeListOwner dragOwner, ChangeListDragBean dragBean) {
    }

    @Override
    public void render(ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        renderer.append(this.userObject.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        String s = " " + (this.myDirsSize > 0 ? this.myDirsSize + " directories and " : "") + (this.myUnversionedSize - this.myDirsSize) + " files ";
        renderer.append(s, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        renderer.append("browse", SimpleTextAttributes.LINK_ATTRIBUTES, this.myShower);
    }

    private static class MyUnversionedShower
    implements Runnable {
        private final Project myProject;

        public MyUnversionedShower(Project project) {
            this.myProject = project;
        }

        @Override
        public void run() {
            UnversionedViewDialog dialog = new UnversionedViewDialog(this.myProject);
            dialog.show();
        }
    }
}

