/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.committed.ChangeListGroupingStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.DateChangeListGroupingStrategy;
import com.intellij.openapi.vcs.changes.committed.LabeledComboBoxAction;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.util.Comparator;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

public class SelectGroupingAction
extends LabeledComboBoxAction {
    private final Project myProject;
    private final CommittedChangesTreeBrowser myBrowser;

    public SelectGroupingAction(Project project, CommittedChangesTreeBrowser browser) {
        super(VcsBundle.message((String)"committed.changes.group.title", (Object[])new Object[0]));
        this.myProject = project;
        this.myBrowser = browser;
        this.getComboBox().setPrototypeDisplayValue("Date+");
    }

    @Override
    protected void selectionChanged(Object selection) {
        this.myBrowser.setGroupingStrategy((ChangeListGroupingStrategy)selection);
    }

    @Override
    protected ComboBoxModel createModel() {
        AbstractVcs[] vcss;
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(new Object[]{new DateChangeListGroupingStrategy(), ChangeListGroupingStrategy.USER});
        for (AbstractVcs vcs : vcss = ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss()) {
            CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
            if (provider == null) continue;
            for (ChangeListColumn column : provider.getColumns()) {
                if (!ChangeListColumn.isCustom((ChangeListColumn)column) || column.getComparator() == null) continue;
                model.addElement(new CustomChangeListColumnGroupingStrategy(column));
            }
        }
        return model;
    }

    private static class CustomChangeListColumnGroupingStrategy
    implements ChangeListGroupingStrategy {
        private final ChangeListColumn<CommittedChangeList> myColumn;

        private CustomChangeListColumnGroupingStrategy(ChangeListColumn column) {
            this.myColumn = column;
        }

        @Override
        public void beforeStart() {
        }

        @Override
        public boolean changedSinceApply() {
            return false;
        }

        @Override
        public String getGroupName(CommittedChangeList changeList) {
            Object value = this.myColumn.getValue((ChangeList)changeList);
            return value != null ? value.toString() : null;
        }

        @Override
        public Comparator<CommittedChangeList> getComparator() {
            return this.myColumn.getComparator();
        }

        public String toString() {
            return this.myColumn.getTitle();
        }
    }
}

