/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vcs.changes.IgnoreSettingsType;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;

public class IgnoredFilesComponent {
    private final Set<IgnoredFileBean> myFilesToIgnore;
    private final Map<String, IgnoredFileBean> myFilesMap;
    private final Set<String> myDirectoriesManuallyRemovedFromIgnored;
    private final ReadWriteLock myLock = new ReentrantReadWriteLock();
    private final Lock myReadLock = this.myLock.readLock();
    private final Lock myWriteLock = this.myLock.writeLock();

    public IgnoredFilesComponent(Project project, boolean registerListener) {
        this.myFilesToIgnore = new LinkedHashSet<IgnoredFileBean>();
        this.myFilesMap = new HashMap<String, IgnoredFileBean>();
        if (registerListener) {
            project.getMessageBus().connect((Disposable)project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

                public void after(@NotNull List<? extends VFileEvent> events) {
                    if (events == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vcs/changes/IgnoredFilesComponent$1", "after"));
                    }
                    if (this.hasSignificantChanges(events)) {
                        IgnoredFilesComponent.this.resetCaches();
                    }
                }

                private <T extends VFileEvent> boolean hasSignificantChanges(List<T> events) {
                    return ContainerUtil.exists(events, (Condition)new Condition<T>(){

                        public boolean value(VFileEvent event) {
                            return !(event instanceof VFileContentChangeEvent);
                        }
                    });
                }
            });
        }
        this.myDirectoriesManuallyRemovedFromIgnored = new HashSet<String>();
    }

    public IgnoredFilesComponent(IgnoredFilesComponent other) {
        this.myFilesToIgnore = new LinkedHashSet<IgnoredFileBean>(other.myFilesToIgnore);
        this.myFilesMap = new HashMap<String, IgnoredFileBean>(other.myFilesMap);
        this.myDirectoriesManuallyRemovedFromIgnored = new HashSet<String>(other.myDirectoriesManuallyRemovedFromIgnored);
    }

    public void add(IgnoredFileBean ... filesToIgnore) {
        this.myWriteLock.lock();
        try {
            Collections.addAll(this.myFilesToIgnore, filesToIgnore);
            this.addIgnoredFiles(filesToIgnore);
        }
        finally {
            this.myWriteLock.unlock();
        }
    }

    public Set<String> getDirectoriesManuallyRemovedFromIgnored() {
        return Collections.unmodifiableSet(this.myDirectoriesManuallyRemovedFromIgnored);
    }

    public void setDirectoriesManuallyRemovedFromIgnored(Set<String> directories) {
        this.myDirectoriesManuallyRemovedFromIgnored.clear();
        this.myDirectoriesManuallyRemovedFromIgnored.addAll(directories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIgnoredDirectoryImplicitly(@NotNull String path, @NotNull Project project) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/changes/IgnoredFilesComponent", "addIgnoredDirectoryImplicitly"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/IgnoredFilesComponent", "addIgnoredDirectoryImplicitly"));
        }
        this.myWriteLock.lock();
        try {
            if (this.myDirectoriesManuallyRemovedFromIgnored.contains(path) || this.myDirectoriesManuallyRemovedFromIgnored.contains(path + "/")) {
                return;
            }
            for (IgnoredFileBean bean : this.myFilesToIgnore) {
                if (bean.getType() != IgnoreSettingsType.UNDER_DIR || !FileUtil.isAncestor((String)bean.getPath(), (String)path, (boolean)false)) continue;
                return;
            }
            ArrayList<IgnoredFileBean> toRemove = new ArrayList<IgnoredFileBean>();
            for (IgnoredFileBean bean : this.myFilesToIgnore) {
                if (bean.getType() != IgnoreSettingsType.UNDER_DIR && bean.getType() != IgnoreSettingsType.FILE || !FileUtil.isAncestor((String)path, (String)bean.getPath(), (boolean)false)) continue;
                toRemove.add(bean);
            }
            this.myFilesToIgnore.removeAll(toRemove);
            this.myFilesToIgnore.add(IgnoredBeanFactory.ignoreUnderDirectory((String)path, (Project)project));
        }
        finally {
            this.myWriteLock.unlock();
        }
    }

    private void addIgnoredFiles(IgnoredFileBean ... filesToIgnore) {
        for (IgnoredFileBean bean : filesToIgnore) {
            Project project;
            VirtualFile baseDir;
            if (!IgnoreSettingsType.FILE.equals((Object)bean.getType()) || (baseDir = (project = bean.getProject()).getBaseDir()) == null) continue;
            this.myFilesMap.put(FilePathsHelper.convertPath((String)baseDir.getPath(), (String)bean.getPath()), bean);
        }
    }

    public void clear() {
        this.myWriteLock.lock();
        try {
            this.myFilesToIgnore.clear();
            this.myFilesMap.clear();
        }
        finally {
            this.myWriteLock.unlock();
        }
    }

    public boolean isEmpty() {
        this.myReadLock.lock();
        try {
            boolean bl = this.myFilesToIgnore.isEmpty();
            return bl;
        }
        finally {
            this.myReadLock.unlock();
        }
    }

    public void set(IgnoredFileBean ... filesToIgnore) {
        this.myWriteLock.lock();
        try {
            this.myFilesToIgnore.clear();
            Collections.addAll(this.myFilesToIgnore, filesToIgnore);
            this.myFilesMap.clear();
            this.addIgnoredFiles(filesToIgnore);
        }
        finally {
            this.myWriteLock.unlock();
        }
    }

    public IgnoredFileBean[] getFilesToIgnore() {
        this.myReadLock.lock();
        try {
            IgnoredFileBean[] ignoredFileBeanArray = this.myFilesToIgnore.toArray(new IgnoredFileBean[this.myFilesToIgnore.size()]);
            return ignoredFileBeanArray;
        }
        finally {
            this.myReadLock.unlock();
        }
    }

    private void resetCaches() {
        this.myWriteLock.lock();
        try {
            for (IgnoredFileBean bean : this.myFilesToIgnore) {
                bean.resetCache();
            }
        }
        finally {
            this.myWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIgnoredFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/IgnoredFilesComponent", "isIgnoredFile"));
        }
        this.myReadLock.lock();
        try {
            if (this.myFilesToIgnore.size() == 0) {
                boolean bl = false;
                return bl;
            }
            String path = FilePathsHelper.convertPath((VirtualFile)file2);
            IgnoredFileBean fileBean = this.myFilesMap.get(path);
            if (fileBean != null && fileBean.matchesFile(file2)) {
                boolean bl = true;
                return bl;
            }
            for (IgnoredFileBean bean : this.myFilesToIgnore) {
                if (!bean.matchesFile(file2)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.myReadLock.unlock();
        }
    }
}

