/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdateSettingsConfigurable;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.Alarm;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class UpdateCheckerComponent
implements ApplicationComponent {
    private static final long CHECK_INTERVAL = 28800000L;
    private final Alarm myCheckForUpdatesAlarm;
    private final Runnable myCheckRunnable;
    private final UpdateSettings mySettings;

    public UpdateCheckerComponent(final @NotNull Application app, @NotNull UpdateSettings settings) {
        if (app == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "app", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent", "<init>"));
        }
        this.myCheckForUpdatesAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
        this.myCheckRunnable = new Runnable(){

            @Override
            public void run() {
                UpdateChecker.updateAndShowResult();
                UpdateCheckerComponent.this.queueNextCheck(28800000L);
            }
        };
        this.mySettings = settings;
        if (this.mySettings.isSecureConnection() && !this.mySettings.canUseSecureConnection()) {
            this.mySettings.setSecureConnection(false);
            boolean tooOld = !SystemInfo.isJavaVersionAtLeast((String)"1.7");
            final String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
            final String message = IdeBundle.message((String)(tooOld ? "update.sni.not.available.message" : "update.sni.disabled.message"), (Object[])new Object[0]);
            app.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateChecker.NOTIFICATIONS.createNotification(title, message, NotificationType.WARNING, (NotificationListener)new NotificationListener.Adapter(){

                        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                            if (notification == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent$2$1", "hyperlinkActivated"));
                            }
                            if (e == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent$2$1", "hyperlinkActivated"));
                            }
                            notification.expire();
                            app.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ShowSettingsUtil.getInstance().showSettingsDialog(null, UpdateSettingsConfigurable.class);
                                }
                            }, ModalityState.NON_MODAL);
                        }
                    }).notify(null);
                }
            }, ModalityState.NON_MODAL);
        }
        this.scheduleOnStartCheck(app);
    }

    private void scheduleOnStartCheck(@NotNull Application app) {
        if (app == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "app", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent", "scheduleOnStartCheck"));
        }
        if (!this.mySettings.isCheckNeeded()) {
            return;
        }
        app.getMessageBus().connect((Disposable)app).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter(){

            @Override
            public void appFrameCreated(String[] commandLineArgs, @NotNull Ref<Boolean> willOpenProject) {
                if (willOpenProject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "willOpenProject", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent$3", "appFrameCreated"));
                }
                UpdateCheckerComponent.this.myCheckRunnable.run();
            }
        });
    }

    private void queueNextCheck(long interval) {
        this.myCheckForUpdatesAlarm.addRequest(this.myCheckRunnable, interval);
    }

    public void initComponent() {
        PluginsAdvertiser.ensureDeleted();
    }

    public void disposeComponent() {
        Disposer.dispose((Disposable)this.myCheckForUpdatesAlarm);
    }

    @NotNull
    public String getComponentName() {
        if ("UpdateCheckerComponent" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent", "getComponentName"));
        }
        return "UpdateCheckerComponent";
    }

    public void queueNextCheck() {
        this.queueNextCheck(28800000L);
    }

    public void cancelChecks() {
        this.myCheckForUpdatesAlarm.cancelAllRequests();
    }
}

