/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraries;

import com.intellij.facet.impl.ui.libraries.LibraryCompositionSettings;
import com.intellij.facet.impl.ui.libraries.LibraryOptionsPanel;
import com.intellij.framework.library.FrameworkLibraryVersionFilter;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ParameterizedRunnable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddCustomLibraryDialog
extends DialogWrapper {
    private final LibraryOptionsPanel myPanel;
    private final LibrariesContainer myLibrariesContainer;
    private final Module myModule;
    private final ModifiableRootModel myModifiableRootModel;
    @Nullable
    private final ParameterizedRunnable<ModifiableRootModel> myBeforeLibraryAdded;
    private final List<Library> myAddedLibraries = new ArrayList<Library>();

    private AddCustomLibraryDialog(CustomLibraryDescription description, LibrariesContainer librariesContainer, Module module, ModifiableRootModel modifiableRootModel, @Nullable ParameterizedRunnable<ModifiableRootModel> beforeLibraryAdded) {
        super(module.getProject(), true);
        this.myLibrariesContainer = librariesContainer;
        this.myModule = module;
        this.myModifiableRootModel = modifiableRootModel;
        this.myBeforeLibraryAdded = beforeLibraryAdded;
        this.setTitle(IdeBundle.message((String)"setup.library.dialog.title", (Object[])new Object[0]));
        VirtualFile baseDir = this.myModule.getProject().getBaseDir();
        String baseDirPath = baseDir != null ? baseDir.getPath() : "";
        this.myPanel = new LibraryOptionsPanel(description, baseDirPath, FrameworkLibraryVersionFilter.ALL, this.myLibrariesContainer, false);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myPanel);
        this.init();
    }

    public static AddCustomLibraryDialog createDialog(@NotNull CustomLibraryDescription description, @NotNull Module module, ParameterizedRunnable<ModifiableRootModel> beforeLibraryAdded) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/openapi/roots/ui/configuration/libraries/AddCustomLibraryDialog", "createDialog"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ui/configuration/libraries/AddCustomLibraryDialog", "createDialog"));
        }
        return AddCustomLibraryDialog.createDialog(description, LibrariesContainerFactory.createContainer(module), module, null, beforeLibraryAdded);
    }

    public static AddCustomLibraryDialog createDialog(CustomLibraryDescription description, @NotNull LibrariesContainer librariesContainer, @NotNull Module module, @Nullable ModifiableRootModel modifiableRootModel, @Nullable ParameterizedRunnable<ModifiableRootModel> beforeLibraryAdded) {
        if (librariesContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "librariesContainer", "com/intellij/openapi/roots/ui/configuration/libraries/AddCustomLibraryDialog", "createDialog"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ui/configuration/libraries/AddCustomLibraryDialog", "createDialog"));
        }
        return new AddCustomLibraryDialog(description, librariesContainer, module, modifiableRootModel, beforeLibraryAdded);
    }

    protected JComponent createCenterPanel() {
        return this.myPanel.getMainPanel();
    }

    protected void doOKAction() {
        final LibraryCompositionSettings settings = this.myPanel.apply();
        DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (settings != null && settings.downloadFiles(AddCustomLibraryDialog.this.myPanel.getMainPanel())) {
                    if (AddCustomLibraryDialog.this.myModifiableRootModel == null) {
                        final ModifiableRootModel model = ModuleRootManager.getInstance((Module)AddCustomLibraryDialog.this.myModule).getModifiableModel();
                        new WriteAction(){

                            protected void run(@NotNull Result result2) {
                                if (result2 == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/roots/ui/configuration/libraries/AddCustomLibraryDialog$1$1", "run"));
                                }
                                AddCustomLibraryDialog.this.addLibraries(model, settings);
                                model.commit();
                            }
                        }.execute();
                    } else {
                        AddCustomLibraryDialog.this.addLibraries(AddCustomLibraryDialog.this.myModifiableRootModel, settings);
                    }
                }
                AddCustomLibraryDialog.super.doOKAction();
            }
        });
    }

    private void addLibraries(ModifiableRootModel model, LibraryCompositionSettings settings) {
        if (this.myBeforeLibraryAdded != null) {
            this.myBeforeLibraryAdded.run((Object)model);
        }
        settings.addLibraries(model, this.myAddedLibraries, this.myLibrariesContainer);
    }

    public List<Library> getAddedLibraries() {
        return this.myAddedLibraries;
    }
}

