/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.FileChooserAction;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;

public final class GotoHomeAction
extends FileChooserAction {
    @Override
    protected void actionPerformed(final FileSystemTree fileSystemTree, AnActionEvent e) {
        final VirtualFile userHomeDir = VfsUtil.getUserHomeDir();
        if (userHomeDir != null) {
            fileSystemTree.select(userHomeDir, new Runnable(){

                @Override
                public void run() {
                    fileSystemTree.expand(userHomeDir, null);
                }
            });
        }
    }

    @Override
    protected void update(FileSystemTree fileSystemTree, AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        if (!presentation.isEnabled()) {
            return;
        }
        VirtualFile userHomeDir = VfsUtil.getUserHomeDir();
        presentation.setEnabled(userHomeDir != null && fileSystemTree.isUnderRoots(userHomeDir));
    }
}

